"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Duration = exports.Description = exports.Default = exports.default = void 0;

var _iconsReact = require("@carbon/icons-react");

var _addonKnobs = require("@storybook/addon-knobs");

var _react = _interopRequireDefault(require("react"));

var _Tooltip = require("./Tooltip");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var _default = {
  title: 'Experimental/unstable_Tooltip',
  component: _Tooltip.Tooltip,
  includeStories: []
};
exports.default = _default;

var Default = function Default() {
  var sizes = ['top', 'top-left', 'top-right', 'bottom', 'bottom-left', 'bottom-right', 'left', 'left-top', 'left-bottom', 'right', 'right-top', 'right-bottom'];
  return /*#__PURE__*/_react.default.createElement(_Tooltip.Tooltip, {
    align: (0, _addonKnobs.select)('Specify where the target should be relative to the tooltip', sizes, 'top'),
    label: "Close"
  }, /*#__PURE__*/_react.default.createElement("button", {
    type: "button"
  }, /*#__PURE__*/_react.default.createElement(_iconsReact.Add24, null)));
};

exports.Default = Default;

var Description = function Description() {
  return /*#__PURE__*/_react.default.createElement(_Tooltip.Tooltip, {
    description: "Modify account settings"
  }, /*#__PURE__*/_react.default.createElement("button", {
    type: "button"
  }, "Edit"));
};

exports.Description = Description;

var Duration = function Duration() {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_Tooltip.Tooltip, {
    label: "Close",
    enterDelayMs: 500,
    leaveDelayMs: 500
  }, /*#__PURE__*/_react.default.createElement("button", {
    type: "button"
  }, /*#__PURE__*/_react.default.createElement(_iconsReact.Add24, null))), /*#__PURE__*/_react.default.createElement(_Tooltip.Tooltip, {
    label: "Close",
    enterDelayMs: 500,
    leaveDelayMs: 500
  }, /*#__PURE__*/_react.default.createElement("button", {
    type: "button"
  }, /*#__PURE__*/_react.default.createElement(_iconsReact.Add24, null))), /*#__PURE__*/_react.default.createElement(_Tooltip.Tooltip, {
    label: "Close",
    enterDelayMs: 500,
    leaveDelayMs: 500
  }, /*#__PURE__*/_react.default.createElement("button", {
    type: "button"
  }, /*#__PURE__*/_react.default.createElement(_iconsReact.Add24, null))));
};

exports.Duration = Duration;