import React from 'react';
import { Props as PopoverProps } from '../../spi/Popover';
/** variants of how the information should be presented */
export declare type ViewLevel = 'removed' | 'hidden' | 'normal' | 'obscured' | 'ok' | 'warn' | 'error' | 'info';
interface Props {
    text: string;
    viewLevel: ViewLevel;
    title?: string;
    className?: string;
    iconIsNarrow?: boolean;
    iconOnclick?: string | (() => void);
    textOnclick?: string | (() => void);
    id?: string;
    popover?: Pick<PopoverProps, 'bodyContent' | 'headerContent'> & Partial<PopoverProps>;
}
export default class TextWithIconWidget extends React.PureComponent<Props> {
    /** Render the content (excluding any popover/tooltip wrappers) part */
    private content;
    render(): JSX.Element;
}
export {};
