import React from 'react';
import { Arguments, ParsedOptions, Tab as KuiTab, Content, MultiModalResponse, ToolbarProps } from '@kui-shell/core';
export declare type KuiMMRProps = ToolbarProps & {
    tab: KuiTab;
    mode: Content;
    isActive: boolean;
    response: MultiModalResponse;
    args: {
        argsForMode?: Arguments;
        argvNoOptions: string[];
        parsedOptions: ParsedOptions;
    };
    execUUID: string;
};
interface State {
    mode: Content;
    execUUID: string;
}
export default class KuiContent extends React.PureComponent<KuiMMRProps, State> {
    constructor(props: KuiMMRProps);
    static getDerivedStateFromProps(props: KuiMMRProps, state?: State): State;
    render(): JSX.Element;
}
export interface Focusable {
    doFocus(): void;
}
export declare function isFocusable(node: React.ReactNode & Partial<Focusable>): node is Focusable;
export {};
