"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _debug = _interopRequireDefault(require("debug"));

var _core = require("@kui-shell/core");

var _delegates = require("../vfs/delegates");

var _head = require("./head");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2021 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

const debug = (0, _debug.default)('plugins/bash-like/cmds/tail');

function tail(args) {
  return __awaiter(this, void 0, void 0, function* () {
    if (args.parsedOptions.q || args.parsedOptions.f || args.parsedOptions.F) {
      return args.REPL.qexec(`sendtopty ${args.command}`, undefined, undefined, Object.assign(args.execOptions, {
        quiet: false
      }));
    }

    const {
      argvNoOptions,
      parsedOptions
    } = args;
    const filepath = argvNoOptions[argvNoOptions.indexOf('tail') + 1];
    debug('tail', filepath);

    if (typeof filepath === 'number' && filepath < 0) {
      // special case for command: e.g. head -10 file
      // change `head -10 file` to `head -n 10 file`
      const newarg = `-n ${filepath * -1}`;
      return args.REPL.qexec(args.command.replace(filepath, newarg));
    }

    const {
      size
    } = (yield args.REPL.rexec(`vfs fstat ${(0, _core.encodeComponent)(filepath)}`)).content;

    try {
      let data = '';

      if (parsedOptions.c) {
        // tail bytes: easy
        data = yield (0, _delegates.fslice)(filepath, size - parsedOptions.c, parsedOptions.c, 'bytes');
      } else {
        // tail lines: a bit harder
        const nLinesDesired = parsedOptions.n || 10;
        let nLinesLeft = nLinesDesired;
        const chunkSize = 4 * 1024;
        let offset = Math.max(0, size - chunkSize);

        while (nLinesLeft > 0 && offset >= 0) {
          const rawData = yield (0, _delegates.fslice)(filepath, offset, -nLinesLeft, 'lines', offset + chunkSize);
          const rawDataNLines = rawData.split(/\n/).length;
          nLinesLeft -= rawDataNLines;
          offset -= chunkSize;
          data += rawData;
        }
      }

      return (0, _head.showResponseAsMMR)(filepath, data);
    } catch (err) {
      throw new Error(`tail: ${err.message}`);
    }
  });
}
/**
 * Register command handlers
 *
 */


var _default = registrar => {
  registrar.listen('/tail', tail, {
    requiresLocal: true,
    flags: {
      boolean: ['f', 'F', 'q']
    }
  });
};

exports.default = _default;