"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = registerOcLogin;

var _pluginKubectl = require("@kui-shell/plugin-kubectl");

/*
 * Copyright 2021 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

function registerOcLogin(registrar) {
  registrar.listen('/oc/login', args => __awaiter(this, void 0, void 0, function* () {
    const command = args.command.replace(/login/, '_login');
    const response = yield args.REPL.qexec(command);
    (0, _pluginKubectl.emitKubectlConfigChangeEvent)('SetNamespaceOrContext');
    return response;
  }));
  registrar.listen('/oc/_login', args => __awaiter(this, void 0, void 0, function* () {
    args.command = args.command.replace(/_login/, 'login');
    args.argvNoOptions[1] = 'login';
    args.argv[1] = 'login';
    const response = yield (0, _pluginKubectl.doExecWithPty)(args, undefined, 'oc');
    (0, _pluginKubectl.emitKubectlConfigChangeEvent)('SetNamespaceOrContext');
    return response;
  }), {
    requiresLocal: true
  });
}