"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactCore = require("@patternfly/react-core");

var _core = require("@kui-shell/core");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const strings = (0, _core.i18n)('plugin-client-common');

class PatternFlyAccordion extends _react.default.PureComponent {
  constructor(props) {
    super(props);
    this.state = {
      expandedIdx: -1
    };
  }

  content(idx) {
    const isHidden = this.state.expandedIdx !== idx;
    return _react.default.createElement(_reactCore.AccordionContent, {
      isHidden: isHidden
    }, !isHidden && this.props.content[idx]());
  }

  render() {
    return _react.default.createElement(_reactCore.Accordion, {
      asDefinitionList: false,
      className: `kui--accordion ${this.props.isWidthConstrained ? 'flex-fill' : ''}`
    }, this.props.names.map((name, idx) => _react.default.createElement("div", {
      key: idx,
      className: "kui--accordion-item"
    }, _react.default.createElement(_reactCore.AccordionItem, null, _react.default.createElement(_reactCore.AccordionToggle, {
      id: idx.toString(),
      onClick: () => {
        this.setState(curState => ({
          expandedIdx: curState.expandedIdx !== idx ? idx : -1
        }));

        _core.eventBus.emitTabLayoutChange((0, _core.getPrimaryTabId)(this.props.tab));
      },
      isExpanded: this.state.expandedIdx === idx
    }, this.state.expandedIdx !== idx ? strings('Show X', name) : strings('Hide X', name)), this.content(idx)))));
  }

}

exports.default = PatternFlyAccordion;