import React from 'react';
import { Tab, REPL, Table as KuiTable, Row as KuiRow } from '@kui-shell/core';
import DefaultColoring, { Coloring } from './Coloring';
/** parameters to Grid component */
export declare type Props<T extends KuiTable = KuiTable> = {
    tab: Tab;
    repl: REPL;
    response: T;
    visibleRows: KuiRow[];
    justUpdated: Record<string, boolean>;
};
export declare const findGridableColumn: (response: KuiTable) => number;
interface State {
    coloring: Coloring;
}
/**
 * A Grid table
 *
 */
export default class Grid<P extends Props> extends React.PureComponent<P, State> {
    constructor(props: P);
    static getDerivedStateFromProps(props: Props): {
        coloring: DefaultColoring;
    };
    private durationCss;
    render(): JSX.Element;
    /** Render as a grid of names */
    private renderWithNames;
    /** Render as a grid of [] square/circle badges */
    private renderWithBadges;
}
export {};
