/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { useRef } from 'react';
import { focus } from '../../internal/focus';
export function useFocusScope(containerRef) {
  var focusScope = useRef(null);

  if (focusScope.current === null) {
    focusScope.current = createFocusScope(containerRef);
  }

  return focusScope;
}

function createFocusWalker(container) {
  return document.createTreeWalker(container, NodeFilter.SHOW_ELEMENT, {
    acceptNode: function acceptNode(node) {
      if (node.tabIndex >= 0 && !node.disabled) {
        return NodeFilter.FILTER_ACCEPT;
      }

      return NodeFilter.FILTER_SKIP;
    }
  });
}

function createFocusScope(root) {
  var focusScope = {
    getFirstDescendant: function getFirstDescendant() {
      var walker = createFocusWalker(root.current);
      return walker.firstChild();
    },
    focusFirstDescendant: function focusFirstDescendant() {
      var walker = createFocusWalker(root.current);
      var firstChild = walker.firstChild();

      if (firstChild) {
        focus(firstChild);
      }
    },
    focusLastDescendant: function focusLastDescendant() {
      var walker = createFocusWalker(root.current);
      var lastChild = walker.lastChild();

      if (lastChild) {
        focus(lastChild);
      }
    }
  };
  return focusScope;
}