function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import { boolean, text } from '@storybook/addon-knobs';
import FormGroup from './FormGroup';
import TextInput from '../TextInput';
import RadioButtonGroup from '../RadioButtonGroup';
import RadioButton from '../RadioButton';
import Button from '../Button';
import mdx from './FormGroup.mdx';

var props = function props() {
  return {
    disabled: boolean('Disabled (disabled)', false),
    legendId: text('Legend ID (legendId)', 'formgroup-legend-id'),
    legendText: text('Legend text (legendText)', 'FormGroup Legend'),
    hasMargin: boolean('Fieldset has bottom margin (hasMargin)', true)
  };
};

export default {
  title: 'Components/FormGroup',
  parameters: {
    component: FormGroup,
    docs: {
      page: mdx
    }
  }
};
export var _Default = function _Default() {
  return /*#__PURE__*/React.createElement(FormGroup, {
    legendId: "formgroup-legend-id",
    legendText: "FormGroup Legend",
    style: {
      maxWidth: '400px'
    }
  }, /*#__PURE__*/React.createElement("div", {
    style: {
      marginBottom: '1rem'
    }
  }, /*#__PURE__*/React.createElement(TextInput, {
    id: "one",
    labelText: "First Name"
  })), /*#__PURE__*/React.createElement("div", {
    style: {
      marginBottom: '1rem'
    }
  }, /*#__PURE__*/React.createElement(TextInput, {
    id: "two",
    labelText: "Last Name"
  })), /*#__PURE__*/React.createElement(RadioButtonGroup, {
    legendText: "Radio button heading",
    name: "radio-button-group",
    defaultSelected: "radio-1"
  }, /*#__PURE__*/React.createElement(RadioButton, {
    labelText: "Option 1",
    value: "radio-1",
    id: "radio-1"
  }), /*#__PURE__*/React.createElement(RadioButton, {
    labelText: "Option 2",
    value: "radio-2",
    id: "radio-2"
  }), /*#__PURE__*/React.createElement(RadioButton, {
    labelText: "Option 3",
    value: "radio-3",
    id: "radio-3"
  })));
};
_Default.story = {
  name: 'Form Group'
};
export var Playground = function Playground() {
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(FormGroup, _extends({
    className: "test"
  }, props(), {
    style: {
      maxWidth: '400px'
    }
  }), /*#__PURE__*/React.createElement(TextInput, {
    id: "one",
    labelText: "First Name",
    style: {
      marginBottom: '1rem'
    }
  }), /*#__PURE__*/React.createElement(TextInput, {
    id: "two",
    labelText: "Last Name",
    style: {
      marginBottom: '1rem'
    }
  }), /*#__PURE__*/React.createElement(RadioButtonGroup, {
    legendText: "Radio button heading",
    name: "radio-button-group",
    defaultSelected: "radio-1"
  }, /*#__PURE__*/React.createElement(RadioButton, {
    labelText: "Option 1",
    value: "radio-1",
    id: "radio-1"
  }), /*#__PURE__*/React.createElement(RadioButton, {
    labelText: "Option 2",
    value: "radio-2",
    id: "radio-2"
  }), /*#__PURE__*/React.createElement(RadioButton, {
    labelText: "Option 3",
    value: "radio-3",
    id: "radio-3"
  }))), /*#__PURE__*/React.createElement(Button, null, "Submit"));
};