function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import Link from '../Link';
import { shallow } from 'enzyme';
import { settings } from 'carbon-components';
import { cleanup, render, screen } from '@testing-library/react';
import userEvent from '@testing-library/user-event';
import { describe, document } from 'window-or-global';
var prefix = settings.prefix;
describe('Link', function () {
  afterEach(cleanup);
  describe('Renders as expected', function () {
    var link = shallow( /*#__PURE__*/React.createElement(Link, {
      href: "www.google.com",
      className: "some-class"
    }, "A simple link"));
    it('should use the appropriate link class', function () {
      expect(link.name()).toEqual('a');
      expect(link.hasClass("".concat(prefix, "--link"))).toEqual(true);
    });
    it('should inherit the href property', function () {
      expect(link.props().href).toEqual('www.google.com');
    });
    it('should include child content', function () {
      expect(link.text()).toEqual('A simple link');
    });
    it('should all for custom classes to be applied', function () {
      expect(link.hasClass('some-class')).toEqual(true);
    });
    it('should support disabled link', function () {
      link.setProps({
        disabled: true
      });
      expect(link.name()).toEqual('p');
      expect(link.hasClass("".concat(prefix, "--link--disabled"))).toEqual(true);
    });
    it('should support inline link', function () {
      link.setProps({
        inline: true
      });
      expect(link.hasClass("".concat(prefix, "--link--inline"))).toEqual(true);
    });
    it('should add support for different link sizes', function () {
      link.setProps({
        size: 'lg'
      });
      expect(link.hasClass("".concat(prefix, "--link--lg"))).toEqual(true);
    });
    it('should add rel="noopener" automatically if target="_blank"', function () {
      link.setProps({
        target: '_blank'
      });
      expect(link.props().rel).toEqual('noopener');
    });
  });
  describe('automated verification testing', function () {
    it('should have no Axe violations', /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
      return regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              render( /*#__PURE__*/React.createElement(Link, {
                href: "/",
                className: "some-class"
              }, "A simple link"));
              _context.next = 3;
              return expect(screen.getByText('A simple link')).toHaveNoAxeViolations();

            case 3:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    })));
    it('should have no Accessibility Checker violations', /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2() {
      return regeneratorRuntime.wrap(function _callee2$(_context2) {
        while (1) {
          switch (_context2.prev = _context2.next) {
            case 0:
              render( /*#__PURE__*/React.createElement("main", null, /*#__PURE__*/React.createElement(Link, {
                href: "/",
                className: "some-class"
              }, "A simple link")));
              _context2.next = 3;
              return expect(screen.getByText('A simple link')).toHaveNoACViolations('Link');

            case 3:
            case "end":
              return _context2.stop();
          }
        }
      }, _callee2);
    })));
  });
  describe('keyboard support', function () {
    it('should receive keyboard focus', function () {
      render( /*#__PURE__*/React.createElement(Link, {
        href: "/",
        className: "some-class"
      }, "A simple link"));
      expect(document.body).toHaveFocus();
      userEvent.tab();
      expect(screen.getByText('A simple link')).toHaveFocus();
    });
    it('should not receive keyboard focus when disabled', function () {
      render( /*#__PURE__*/React.createElement(Link, {
        href: "/",
        disabled: true,
        className: "some-class"
      }, "A simple link"));
      expect(document.body).toHaveFocus();
      userEvent.tab();
      expect(document.body).toHaveFocus();
    });
  });
});