function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import './tile-story.scss';
import { withKnobs, boolean, number, select, text } from '@storybook/addon-knobs';
import { Tile, ClickableTile, SelectableTile, ExpandableTile, TileAboveTheFoldContent, TileBelowTheFoldContent } from '../Tile';
import TextInput from '../TextInput';
import TileGroup from '../TileGroup';
import RadioTile from '../RadioTile';
import Link from '../Link';
import mdx from './Tile.mdx';
var radioValues = {
  None: '',
  standard: 'standard',
  'default-selected': 'default-selected',
  selected: 'selected'
};
var props = {
  regular: function regular() {
    return {
      light: boolean('Light variant (light)', false)
    };
  },
  clickable: function clickable() {
    return {
      disabled: boolean('disabled (disabled)', false),
      href: text('Href for clickable UI (href)', 'https://www.carbondesignsystem.com/'),
      light: boolean('Light variant (light)', false)
    };
  },
  selectable: function selectable() {
    return {
      selected: boolean('Selected (selected)', false),
      light: boolean('Light variant (light)', false),
      disabled: boolean('Disabled (disabled)', false)
    };
  },
  group: function group() {
    return {
      name: text('Form item (name in <TileGroup>)', 'tile-group'),
      valueSelected: select('Value of the selected item (valueSelected in <TileGroup>)', radioValues, '')
    };
  },
  radio: function radio() {
    return {
      name: text('Form item name (name in <RadioTile>)', 'tiles'),
      light: boolean('Light variant (light)', false),
      disabled: boolean('Disabled (disabled)', false)
    };
  },
  expandable: function expandable() {
    return {
      tabIndex: number('Tab index (tabIndex)', 0),
      expanded: boolean('Expanded (expanded)', false),
      tileCollapsedIconText: text('Collapsed icon text (tileCollapsedIconText)', 'Interact to Expand tile'),
      tileExpandedIconText: text('Collapsed icon text (tileExpandedIconText)', 'Interact to Collapse tile'),
      tileCollapsedLabel: text('Collapsed icon text (tileCollapsedLabel)'),
      tileExpandedLabel: text('Collapsed icon text (tileExpandedLabel)'),
      light: boolean('Light variant (light)', false)
    };
  }
};
export default {
  title: 'Components/Tile',
  decorators: [withKnobs],
  parameters: {
    component: Tile,
    docs: {
      page: mdx
    },
    subcomponents: {
      ClickableTile: ClickableTile,
      SelectableTile: SelectableTile,
      ExpandableTile: ExpandableTile,
      RadioTile: RadioTile,
      TileGroup: TileGroup,
      TileAboveTheFoldContent: TileAboveTheFoldContent,
      TileBelowTheFoldContent: TileBelowTheFoldContent
    }
  }
};
export var Default = function Default() {
  var regularProps = props.regular();
  return /*#__PURE__*/React.createElement(Tile, regularProps, "Default tile", /*#__PURE__*/React.createElement("br", null), /*#__PURE__*/React.createElement("br", null), /*#__PURE__*/React.createElement(Link, {
    href: "https://www.carbondesignsystem.com"
  }, "Link"));
};
export var Clickable = function Clickable() {
  var clickableProps = props.clickable();
  return /*#__PURE__*/React.createElement(ClickableTile, clickableProps, "Clickable Tile");
};
export var MultiSelect = function MultiSelect() {
  var selectableProps = props.selectable();
  return /*#__PURE__*/React.createElement("div", {
    role: "group",
    "aria-label": "selectable tiles"
  }, /*#__PURE__*/React.createElement(SelectableTile, _extends({
    id: "tile-1",
    name: "tiles"
  }, selectableProps), "Option 1"), /*#__PURE__*/React.createElement(SelectableTile, _extends({
    id: "tile-2",
    name: "tiles"
  }, selectableProps), "Option 2"), /*#__PURE__*/React.createElement(SelectableTile, _extends({
    id: "tile-3",
    name: "tiles"
  }, selectableProps), "Option 3"));
};
export var Radio = function Radio() {
  var radioProps = props.radio();
  return /*#__PURE__*/React.createElement(TileGroup, _extends({
    defaultSelected: "default-selected",
    legend: "Radio Tile Group"
  }, props.group()), /*#__PURE__*/React.createElement(RadioTile, _extends({
    value: "standard"
  }, radioProps), "Option 1"), /*#__PURE__*/React.createElement(RadioTile, _extends({
    value: "default-selected",
    id: "tile-2"
  }, radioProps), "Option 2"), /*#__PURE__*/React.createElement(RadioTile, _extends({
    value: "selected",
    id: "tile-3"
  }, radioProps), "Option 3"));
};
export var Expandable = function Expandable() {
  return /*#__PURE__*/React.createElement(ExpandableTile, props.expandable(), /*#__PURE__*/React.createElement(TileAboveTheFoldContent, null, /*#__PURE__*/React.createElement("div", {
    style: {
      height: '200px'
    }
  }, "Above the fold content here")), /*#__PURE__*/React.createElement(TileBelowTheFoldContent, null, /*#__PURE__*/React.createElement("div", {
    style: {
      height: '400px'
    }
  }, "Below the fold content here", /*#__PURE__*/React.createElement(TextInput, {
    id: "test2",
    invalidText: "A valid value is required"
  })), /*#__PURE__*/React.createElement(Link, null, "hello")));
};