function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import { action } from '@storybook/addon-actions';
import { withKnobs, text, boolean } from '@storybook/addon-knobs';
import ToggleSmall from '../ToggleSmall';

var toggleProps = function toggleProps() {
  return {
    labelText: text('Label toggle input control (labelText)', 'Toggle element label'),
    className: 'some-class',
    labelA: text('Label for untoggled state (labelA)', ''),
    labelB: text('Label for toggled state (labelB)', ''),
    disabled: boolean('Disabled (disabled)', false),
    onChange: action('onChange'),
    onToggle: action('onToggle')
  };
};

export default {
  title: 'Deprecated/ToggleSmall',
  decorators: [withKnobs],
  parameters: {
    component: ToggleSmall,
    subcomponents: {}
  }
};
export var Default = function Default() {
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("h4", null, "This component has been deprecated, please use the `size` prop provided by Toggle instead"), /*#__PURE__*/React.createElement("br", null), /*#__PURE__*/React.createElement(ToggleSmall, _extends({
    defaultToggled: true
  }, toggleProps(), {
    className: "some-class",
    id: "toggle-1"
  })));
};
Default.storyName = 'toggled';
Default.parameters = {
  info: {
    text: "\n        Toggles are controls that are used to quickly switch between two possible states. The example below shows\n        an uncontrolled Toggle component. To use the Toggle component as a controlled component, set the toggled property.\n        Setting the toggled property will allow you to change the value dynamically, whereas setting the defaultToggled\n        prop will only set the value initially. This example has defaultToggled set to true. Small toggles may be used\n        when there is not enough space for a regular sized toggle. This issue is most commonly found in tables.\n      "
  }
};