var _excluded = ["children", "renderIcon", "isExpanded"];

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React, { useState } from 'react';
import { Document16, Folder16 } from '@carbon/icons-react';
import { action } from '@storybook/addon-actions';
import { boolean, object, select, text, withKnobs } from '@storybook/addon-knobs';
import { InlineNotification } from '../Notification';
import TreeView, { TreeNode } from '../TreeView';
import './story.scss';
var sizes = {
  default: 'default',
  compact: 'compact'
};

var props = function props() {
  return {
    active: text('Active node ID (active)', '5'),
    hideLabel: boolean('Visible label (hideLabel)', false),
    label: text('Label (label)', 'Tree view'),
    multiselect: boolean('Allow selection of multiple tree nodes (multiselect)', false),
    onSelect: action('onSelect (TreeView onSelect)'),
    selected: object('Array of selected node IDs (selected)', ['5']),
    size: select('Tree size (sizes)', sizes, 'default')
  };
};

var nodes = [{
  id: '1',
  value: 'Artificial intelligence',
  label: /*#__PURE__*/React.createElement("span", null, "Artificial intelligence"),
  renderIcon: Document16,
  onSelect: action('onSelect (TreeNode onSelect)'),
  onToggle: action('onToggle')
}, {
  id: '2',
  value: 'Blockchain',
  label: 'Blockchain',
  renderIcon: Document16,
  onSelect: action('onSelect (TreeNode onSelect)'),
  onToggle: action('onToggle')
}, {
  id: '3',
  value: 'Business automation',
  label: 'Business automation',
  renderIcon: Folder16,
  onSelect: action('onSelect (TreeNode onSelect)'),
  onToggle: action('onToggle'),
  children: [{
    id: '3-1',
    value: 'Business process automation',
    label: 'Business process automation',
    renderIcon: Document16,
    onSelect: action('onSelect (TreeNode onSelect)'),
    onToggle: action('onToggle')
  }, {
    id: '3-2',
    value: 'Business process mapping',
    label: 'Business process mapping',
    renderIcon: Document16,
    onSelect: action('onSelect (TreeNode onSelect)'),
    onToggle: action('onToggle')
  }]
}, {
  id: '4',
  value: 'Business operations',
  label: 'Business operations',
  renderIcon: Document16,
  onSelect: action('onSelect (TreeNode onSelect)'),
  onToggle: action('onToggle')
}, {
  id: '5',
  value: 'Cloud computing',
  label: 'Cloud computing',
  isExpanded: true,
  renderIcon: Folder16,
  onSelect: action('onSelect (TreeNode onSelect)'),
  onToggle: action('onToggle'),
  children: [{
    id: '5-1',
    value: 'Containers',
    label: 'Containers',
    renderIcon: Document16,
    onSelect: action('onSelect (TreeNode onSelect)'),
    onToggle: action('onToggle')
  }, {
    id: '5-2',
    value: 'Databases',
    label: 'Databases',
    renderIcon: Document16,
    onSelect: action('onSelect (TreeNode onSelect)'),
    onToggle: action('onToggle')
  }, {
    id: '5-3',
    value: 'DevOps',
    label: 'DevOps',
    isExpanded: true,
    renderIcon: Folder16,
    onSelect: action('onSelect (TreeNode onSelect)'),
    onToggle: action('onToggle'),
    children: [{
      id: '5-4',
      value: 'Solutions',
      label: 'Solutions',
      renderIcon: Document16,
      onSelect: action('onSelect (TreeNode onSelect)'),
      onToggle: action('onToggle')
    }, {
      id: '5-5',
      value: 'Case studies',
      label: 'Case studies',
      isExpanded: true,
      renderIcon: Folder16,
      onSelect: action('onSelect (TreeNode onSelect)'),
      onToggle: action('onToggle'),
      children: [{
        id: '5-6',
        value: 'Resources',
        label: 'Resources',
        renderIcon: Document16,
        onSelect: action('onSelect (TreeNode onSelect)'),
        onToggle: action('onToggle')
      }]
    }]
  }]
}, {
  id: '6',
  value: 'Data & Analytics',
  label: 'Data & Analytics',
  renderIcon: Folder16,
  onSelect: action('onSelect (TreeNode onSelect)'),
  onToggle: action('onToggle'),
  children: [{
    id: '6-1',
    value: 'Big data',
    label: 'Big data',
    renderIcon: Document16,
    onSelect: action('onSelect (TreeNode onSelect)'),
    onToggle: action('onToggle')
  }, {
    id: '6-2',
    value: 'Business intelligence',
    label: 'Business intelligence',
    renderIcon: Document16,
    onSelect: action('onSelect (TreeNode onSelect)'),
    onToggle: action('onToggle')
  }]
}, {
  id: '7',
  value: 'IT infrastructure',
  label: 'IT infrastructure',
  isExpanded: true,
  disabled: true,
  renderIcon: Folder16,
  onSelect: action('onSelect (TreeNode onSelect)'),
  onToggle: action('onToggle'),
  children: [{
    id: '7-1',
    value: 'Data storage',
    label: 'Data storage',
    renderIcon: Document16,
    onSelect: action('onSelect (TreeNode onSelect)'),
    onToggle: action('onToggle')
  }, {
    id: '7-2',
    value: 'Enterprise servers',
    label: 'Enterprise servers',
    renderIcon: Document16,
    onSelect: action('onSelect (TreeNode onSelect)'),
    onToggle: action('onToggle')
  }, {
    id: '8',
    value: 'Hybrid cloud infrastructure',
    label: 'Hybrid cloud infrastructure',
    isExpanded: true,
    renderIcon: Folder16,
    onSelect: action('onSelect (TreeNode onSelect)'),
    onToggle: action('onToggle'),
    children: [{
      id: '8-1',
      value: 'Insights',
      label: 'Insights',
      renderIcon: Document16,
      onSelect: action('onSelect (TreeNode onSelect)'),
      onToggle: action('onToggle')
    }, {
      id: '8-2',
      value: 'Benefits',
      label: 'Benefits',
      renderIcon: Document16,
      onSelect: action('onSelect (TreeNode onSelect)'),
      onToggle: action('onToggle')
    }]
  }]
}];

function renderTree(_ref) {
  var nodes = _ref.nodes,
      expanded = _ref.expanded,
      _ref$withIcons = _ref.withIcons,
      withIcons = _ref$withIcons === void 0 ? false : _ref$withIcons;

  if (!nodes) {
    return;
  }

  return nodes.map(function (_ref2) {
    var children = _ref2.children,
        renderIcon = _ref2.renderIcon,
        isExpanded = _ref2.isExpanded,
        nodeProps = _objectWithoutProperties(_ref2, _excluded);

    return /*#__PURE__*/React.createElement(TreeNode, _extends({
      key: nodeProps.id,
      renderIcon: withIcons ? renderIcon : null,
      isExpanded: expanded !== null && expanded !== void 0 ? expanded : isExpanded
    }, nodeProps), renderTree({
      nodes: children,
      expanded: expanded,
      withIcons: withIcons
    }));
  });
}

export default {
  title: 'Experimental/unstable_TreeView',
  decorators: [withKnobs],
  parameters: {
    component: TreeView
  }
};
export var Default = function Default() {
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(InlineNotification, {
    kind: "info",
    title: "Experimental component",
    subtitle: "An accessibility review of this component is in progress"
  }), /*#__PURE__*/React.createElement(TreeView, props(), renderTree({
    nodes: nodes
  })));
};
Default.storyName = 'default';
Default.parameters = {
  info: {
    text: ""
  }
};
export var WithIcons = function WithIcons() {
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(InlineNotification, {
    kind: "info",
    title: "Experimental component",
    subtitle: "An accessibility review of this component is in progress"
  }), /*#__PURE__*/React.createElement(TreeView, props(), renderTree({
    nodes: nodes,
    withIcons: true
  })));
};
WithIcons.storyName = 'with icons';
export var WithControlledExpansion = function WithControlledExpansion() {
  var _useState = useState(undefined),
      _useState2 = _slicedToArray(_useState, 2),
      expanded = _useState2[0],
      setExpanded = _useState2[1];

  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(InlineNotification, {
    kind: "info",
    title: "Experimental component",
    subtitle: "An accessibility review of this component is in progress"
  }), /*#__PURE__*/React.createElement("div", {
    style: {
      marginBottom: '1rem'
    }
  }, /*#__PURE__*/React.createElement("button", {
    type: "button",
    onClick: function onClick() {
      return setExpanded(true);
    }
  }, "expand all"), /*#__PURE__*/React.createElement("button", {
    type: "button",
    onClick: function onClick() {
      return setExpanded(false);
    }
  }, "collapse all")), /*#__PURE__*/React.createElement(TreeView, props(), renderTree({
    nodes: nodes,
    expanded: expanded
  })));
};