"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _keyboard = require("../../internal/keyboard");

var _types = require("../../prop-types/types");

var _uniqueId = _interopRequireDefault(require("../../tools/uniqueId"));

var _usePrefix = require("../../internal/usePrefix");

var _excluded = ["accept", "buttonKind", "className", "disabled", "disableLabelChanges", "id", "labelText", "multiple", "onChange", "role", "name", "size", "tabIndex"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function noop() {}

function FileUploaderButton(_ref) {
  var _cx;

  var accept = _ref.accept,
      _ref$buttonKind = _ref.buttonKind,
      buttonKind = _ref$buttonKind === void 0 ? 'primary' : _ref$buttonKind,
      className = _ref.className,
      _ref$disabled = _ref.disabled,
      disabled = _ref$disabled === void 0 ? false : _ref$disabled,
      _ref$disableLabelChan = _ref.disableLabelChanges,
      disableLabelChanges = _ref$disableLabelChan === void 0 ? false : _ref$disableLabelChan,
      id = _ref.id,
      _ref$labelText = _ref.labelText,
      ownerLabelText = _ref$labelText === void 0 ? 'Add file' : _ref$labelText,
      _ref$multiple = _ref.multiple,
      multiple = _ref$multiple === void 0 ? false : _ref$multiple,
      _ref$onChange = _ref.onChange,
      onChange = _ref$onChange === void 0 ? noop : _ref$onChange,
      _ref$role = _ref.role,
      role = _ref$role === void 0 ? 'button' : _ref$role,
      name = _ref.name,
      size = _ref.size,
      _ref$tabIndex = _ref.tabIndex,
      tabIndex = _ref$tabIndex === void 0 ? 0 : _ref$tabIndex,
      other = _objectWithoutProperties(_ref, _excluded);

  var prefix = (0, _usePrefix.usePrefix)();

  var _useState = (0, _react.useState)(ownerLabelText),
      _useState2 = _slicedToArray(_useState, 2),
      labelText = _useState2[0],
      setLabelText = _useState2[1];

  var _useState3 = (0, _react.useState)(ownerLabelText),
      _useState4 = _slicedToArray(_useState3, 2),
      prevOwnerLabelText = _useState4[0],
      setPrevOwnerLabelText = _useState4[1];

  var _useRef = (0, _react.useRef)(id || (0, _uniqueId.default)()),
      inputId = _useRef.current;

  var inputNode = (0, _react.useRef)(null);
  var classes = (0, _classnames.default)("".concat(prefix, "--btn"), className, (_cx = {}, _defineProperty(_cx, "".concat(prefix, "--btn--").concat(buttonKind), buttonKind), _defineProperty(_cx, "".concat(prefix, "--btn--disabled"), disabled), _defineProperty(_cx, "".concat(prefix, "--btn--md"), size === 'field' || size === 'md'), _defineProperty(_cx, "".concat(prefix, "--btn--sm"), size === 'small' || size === 'sm'), _cx)); // Adjust label text state based on changes to the labelText prop

  if (ownerLabelText !== prevOwnerLabelText) {
    setLabelText(ownerLabelText);
    setPrevOwnerLabelText(ownerLabelText);
  }

  function onClick(event) {
    event.target.value = null;
  }

  function onKeyDown(event) {
    if ((0, _keyboard.matches)(event, [_keyboard.keys.Enter, _keyboard.keys.Space])) {
      inputNode.current.click();
    }
  }

  function handleOnChange(event) {
    var files = event.target.files;
    var length = event.target.files.length;

    if (files && !disableLabelChanges) {
      if (length > 1) {
        setLabelText("".concat(length, " files"));
      } else if (length === 1) {
        setLabelText(files[0].name);
      }
    }

    onChange(event);
  }

  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("label", _extends({
    tabIndex: disabled ? -1 : tabIndex || 0,
    className: classes,
    onKeyDown: onKeyDown,
    htmlFor: inputId
  }, other), /*#__PURE__*/_react.default.createElement("span", {
    role: role,
    "aria-disabled": disabled
  }, labelText)), /*#__PURE__*/_react.default.createElement("input", {
    className: "".concat(prefix, "--visually-hidden"),
    ref: inputNode,
    id: inputId,
    disabled: disabled,
    type: "file",
    tabIndex: "-1",
    multiple: multiple,
    accept: accept,
    name: name,
    onChange: handleOnChange,
    onClick: onClick
  }));
}

FileUploaderButton.propTypes = {
  /**
   * Specify the types of files that this input should be able to receive
   */
  accept: _propTypes.default.arrayOf(_propTypes.default.string),

  /**
   * Specify the type of underlying button
   */
  buttonKind: _propTypes.default.oneOf(_types.ButtonKinds),

  /**
   * Provide a custom className to be applied to the container node
   */
  className: _propTypes.default.string,

  /**
   * Specify whether you want to disable any updates to the FileUploaderButton
   * label
   */
  disableLabelChanges: _propTypes.default.bool,

  /**
   * Specify whether file input is disabled
   */
  disabled: _propTypes.default.bool,

  /**
   * Provide a unique id for the underlying <input> node
   */
  id: _propTypes.default.string,

  /**
   * Provide the label text to be read by screen readers when interacting with
   * this control
   */
  labelText: _propTypes.default.node,

  /**
   * Specify whether you want the component to list the files that have been
   * submitted to be uploaded
   */
  listFiles: _propTypes.default.bool,

  /**
   * Specify if the component should accept multiple files to upload
   */
  multiple: _propTypes.default.bool,

  /**
   * Provide a name for the underlying <input> node
   */
  name: _propTypes.default.string,

  /**
   * Provide an optional `onChange` hook that is called each time the <input>
   * value changes
   */
  onChange: _propTypes.default.func,

  /**
   * Provide an optional `onClick` hook that is called each time the button is
   * clicked
   */
  onClick: _propTypes.default.func,

  /**
   * Provide an accessibility role for the <FileUploaderButton>
   */
  role: _propTypes.default.string,

  /**
   * Specify the size of the FileUploaderButton, from a list of available
   * sizes. For `default` buttons, this prop can remain unspecified.
   * V11: `default`, `field`, and `small` will be removed
   */
  size: _propTypes.default.oneOf(['default', 'field', 'small', 'sm', 'md', 'lg']),

  /**
   * Provide a custom tabIndex value for the <FileUploaderButton>
   */
  tabIndex: _propTypes.default.number
};
var _default = FileUploaderButton;
exports.default = _default;