"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _iconsReact = require("@carbon/icons-react");

var _carbonComponents = require("carbon-components");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _Loading = _interopRequireDefault(require("../Loading"));

var _excluded = ["iconDescription", "status", "invalid"];

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var prefix = _carbonComponents.settings.prefix;

function Filename(_ref) {
  var iconDescription = _ref.iconDescription,
      status = _ref.status,
      invalid = _ref.invalid,
      rest = _objectWithoutProperties(_ref, _excluded);

  switch (status) {
    case 'uploading':
      return /*#__PURE__*/_react.default.createElement(_Loading.default, {
        description: iconDescription,
        small: true,
        withOverlay: false
      });

    case 'edit':
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, invalid && /*#__PURE__*/_react.default.createElement(_iconsReact.WarningFilled16, {
        className: "".concat(prefix, "--file-invalid")
      }), /*#__PURE__*/_react.default.createElement("button", _extends({
        "aria-label": iconDescription,
        className: "".concat(prefix, "--file-close"),
        type: "button"
      }, rest), /*#__PURE__*/_react.default.createElement(_iconsReact.Close16, null)));

    case 'complete':
      return /*#__PURE__*/_react.default.createElement(_iconsReact.CheckmarkFilled16, _extends({
        "aria-label": iconDescription,
        className: "".concat(prefix, "--file-complete")
      }, rest), iconDescription && /*#__PURE__*/_react.default.createElement("title", null, iconDescription));

    default:
      return null;
  }
}

Filename.propTypes = {
  /**
   * Provide a description of the SVG icon to denote file upload status
   */
  iconDescription: _propTypes.default.string,

  /**
   * Specify if the file is invalid
   */
  invalid: _propTypes.default.bool,

  /**
   * Status of the file upload
   */
  status: _propTypes.default.oneOf(['edit', 'complete', 'uploading']),

  /**
   * Provide a custom tabIndex value for the <Filename>
   */
  tabIndex: _propTypes.default.string
};
Filename.defaultProps = {
  iconDescription: 'Uploading file',
  status: 'uploading',
  tabIndex: '0'
};
var _default = Filename;
exports.default = _default;