"use strict";

var _react = _interopRequireDefault(require("react"));

var _Link = _interopRequireDefault(require("../Link"));

var _enzyme = require("enzyme");

var _carbonComponents = require("carbon-components");

var _react2 = require("@testing-library/react");

var _userEvent = _interopRequireDefault(require("@testing-library/user-event"));

var _windowOrGlobal = require("window-or-global");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

var prefix = _carbonComponents.settings.prefix;
(0, _windowOrGlobal.describe)('Link', function () {
  afterEach(_react2.cleanup);
  (0, _windowOrGlobal.describe)('Renders as expected', function () {
    var link = (0, _enzyme.shallow)( /*#__PURE__*/_react.default.createElement(_Link.default, {
      href: "www.google.com",
      className: "some-class"
    }, "A simple link"));
    it('should use the appropriate link class', function () {
      expect(link.name()).toEqual('a');
      expect(link.hasClass("".concat(prefix, "--link"))).toEqual(true);
    });
    it('should inherit the href property', function () {
      expect(link.props().href).toEqual('www.google.com');
    });
    it('should include child content', function () {
      expect(link.text()).toEqual('A simple link');
    });
    it('should all for custom classes to be applied', function () {
      expect(link.hasClass('some-class')).toEqual(true);
    });
    it('should support disabled link', function () {
      link.setProps({
        disabled: true
      });
      expect(link.name()).toEqual('p');
      expect(link.hasClass("".concat(prefix, "--link--disabled"))).toEqual(true);
    });
    it('should support inline link', function () {
      link.setProps({
        inline: true
      });
      expect(link.hasClass("".concat(prefix, "--link--inline"))).toEqual(true);
    });
    it('should add support for different link sizes', function () {
      link.setProps({
        size: 'lg'
      });
      expect(link.hasClass("".concat(prefix, "--link--lg"))).toEqual(true);
    });
    it('should add rel="noopener" automatically if target="_blank"', function () {
      link.setProps({
        target: '_blank'
      });
      expect(link.props().rel).toEqual('noopener');
    });
  });
  (0, _windowOrGlobal.describe)('automated verification testing', function () {
    it('should have no Axe violations', /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
      return regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Link.default, {
                href: "/",
                className: "some-class"
              }, "A simple link"));
              _context.next = 3;
              return expect(_react2.screen.getByText('A simple link')).toHaveNoAxeViolations();

            case 3:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    })));
    it('should have no Accessibility Checker violations', /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2() {
      return regeneratorRuntime.wrap(function _callee2$(_context2) {
        while (1) {
          switch (_context2.prev = _context2.next) {
            case 0:
              (0, _react2.render)( /*#__PURE__*/_react.default.createElement("main", null, /*#__PURE__*/_react.default.createElement(_Link.default, {
                href: "/",
                className: "some-class"
              }, "A simple link")));
              _context2.next = 3;
              return expect(_react2.screen.getByText('A simple link')).toHaveNoACViolations('Link');

            case 3:
            case "end":
              return _context2.stop();
          }
        }
      }, _callee2);
    })));
  });
  (0, _windowOrGlobal.describe)('keyboard support', function () {
    it('should receive keyboard focus', function () {
      (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Link.default, {
        href: "/",
        className: "some-class"
      }, "A simple link"));
      expect(_windowOrGlobal.document.body).toHaveFocus();

      _userEvent.default.tab();

      expect(_react2.screen.getByText('A simple link')).toHaveFocus();
    });
    it('should not receive keyboard focus when disabled', function () {
      (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Link.default, {
        href: "/",
        disabled: true,
        className: "some-class"
      }, "A simple link"));
      expect(_windowOrGlobal.document.body).toHaveFocus();

      _userEvent.default.tab();

      expect(_windowOrGlobal.document.body).toHaveFocus();
    });
  });
});