"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.customItemToString = exports.generateItems = exports.generateCustomItem = exports.generateGenericItem = exports.assertMenuClosed = exports.assertMenuOpen = exports.openMenu = exports.findPopupNode = exports.findComboboxNode = exports.findFieldNode = exports.findMenuIconNode = exports.findMenuItemNode = exports.findMenuNode = exports.findListBoxNode = void 0;

var _carbonComponents = require("carbon-components");

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var prefix = _carbonComponents.settings.prefix; // Finding nodes in a ListBox

var findListBoxNode = function findListBoxNode(wrapper) {
  return wrapper.find(".".concat(prefix, "--list-box"));
};

exports.findListBoxNode = findListBoxNode;

var findMenuNode = function findMenuNode(wrapper) {
  return wrapper.find(".".concat(prefix, "--list-box__menu"));
};

exports.findMenuNode = findMenuNode;

var findMenuItemNode = function findMenuItemNode(wrapper, index) {
  return wrapper.find('ListBoxMenuItem').at(index);
};

exports.findMenuItemNode = findMenuItemNode;

var findMenuIconNode = function findMenuIconNode(wrapper) {
  return wrapper.find(".".concat(prefix, "--list-box__menu-icon"));
};

exports.findMenuIconNode = findMenuIconNode;

var findFieldNode = function findFieldNode(wrapper) {
  return wrapper.find(".".concat(prefix, "--list-box__field"));
};

exports.findFieldNode = findFieldNode;

var findComboboxNode = function findComboboxNode(wrapper) {
  return wrapper.find(".".concat(prefix, "--list-box[role=\"combobox\"]"));
};

exports.findComboboxNode = findComboboxNode;

var findPopupNode = function findPopupNode(wrapper) {
  return wrapper.find('[aria-haspopup="listbox"]').hostNodes();
}; // Actions


exports.findPopupNode = findPopupNode;

var openMenu = function openMenu(wrapper) {
  return findFieldNode(wrapper).simulate('click');
}; // Common assertions, useful for validating a11y props are set when needed


exports.openMenu = openMenu;

var assertMenuOpen = function assertMenuOpen(wrapper, mockProps) {
  expect(findMenuNode(wrapper).children().length).toBe(mockProps.items.length);
  expect(findMenuIconNode(wrapper).prop('className')).toEqual(expect.stringContaining("".concat(prefix, "--list-box__menu-icon--open")));
  expect(findPopupNode(wrapper).prop('aria-expanded')).toBe(true);
};

exports.assertMenuOpen = assertMenuOpen;

var assertMenuClosed = function assertMenuClosed(wrapper) {
  expect(findMenuIconNode(wrapper).prop('className')).toEqual(expect.stringContaining("".concat(prefix, "--list-box__menu-icon")));
  expect(findMenuIconNode(wrapper).prop('className')).not.toEqual(expect.stringContaining("".concat(prefix, "--list-box__menu-icon--open")));
  expect(findPopupNode(wrapper).prop('aria-expanded')).toBe(false);
};
/**
 * `GenericItem` corresponds to an item in a collection that is passed to
 * MultiSelect that is in a predictable shape and works with the default
 * `itemToString` out of the box.
 * @param {number} index
 *
 * @returns {{id: string, label: string, value: string}}
 */


exports.assertMenuClosed = assertMenuClosed;

var generateGenericItem = function generateGenericItem(index) {
  return {
    id: "id-".concat(index),
    label: "Item ".concat(index),
    value: index
  };
};
/**
 * `CustomItem` corresponds to a potentially different item structure that
 * might be passed into MultiSelect that we would need to supply a custom
 * `itemToString` method for
 * @param {number} index
 *
 * @returns {{field: string, value: string}}
 */


exports.generateGenericItem = generateGenericItem;

var generateCustomItem = function generateCustomItem(index) {
  return {
    field: "Item ".concat(index),
    value: "Custom value ".concat(index)
  };
};
/**
 * Returns an Array filled by values generated by the `generator` function
 * @param {number} amount Number of elements to generate
 *
 * @returns {Array<object>} Array of objects generated by `generator`
 */


exports.generateCustomItem = generateCustomItem;

var generateItems = function generateItems(amount, generator) {
  return Array(amount).fill(null).map(function (_, i) {
    return generator(i);
  });
};

exports.generateItems = generateItems;

var customItemToString = function customItemToString(_ref) {
  var field = _ref.field;
  return field;
};

exports.customItemToString = customItemToString;