"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Playground = exports.RenderCustomIcon = exports._Default = exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _addonActions = require("@storybook/addon-actions");

var _addonKnobs = require("@storybook/addon-knobs");

var _OverflowMenu = require("./OverflowMenu");

var _OverflowMenuItem = _interopRequireDefault(require("../OverflowMenuItem"));

var _OverflowMenu2 = _interopRequireDefault(require("./OverflowMenu.mdx"));

var _iconsReact = require("@carbon/icons-react");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var directions = {
  'Bottom of the trigger button (bottom)': 'bottom',
  'Top of the trigger button (top)': 'top'
};
var sizes = {
  'Small  (sm)': 'sm',
  'Medium (md) - default': undefined,
  'Large  (lg)': 'lg'
};
var props = {
  menu: function menu() {
    return {
      direction: (0, _addonKnobs.select)('Menu direction (direction)', directions, 'bottom'),
      ariaLabel: (0, _addonKnobs.text)('ARIA label (ariaLabel)', 'Menu'),
      iconDescription: (0, _addonKnobs.text)('Icon description (iconDescription)', ''),
      flipped: (0, _addonKnobs.boolean)('Flipped (flipped)', false),
      light: (0, _addonKnobs.boolean)('Light (light)', false),
      selectorPrimaryFocus: (0, _addonKnobs.text)('Primary focus element selector (selectorPrimaryFocus)', ''),
      size: (0, _addonKnobs.select)('Size (size)', sizes, undefined) || undefined,
      onClick: (0, _addonActions.action)('onClick'),
      onFocus: (0, _addonActions.action)('onFocus'),
      onKeyDown: (0, _addonActions.action)('onKeyDown'),
      onClose: (0, _addonActions.action)('onClose'),
      onOpen: (0, _addonActions.action)('onOpen')
    };
  },
  menuItem: function menuItem() {
    return {
      className: 'some-class',
      disabled: (0, _addonKnobs.boolean)('Disabled (disabled)', false),
      requireTitle: (0, _addonKnobs.boolean)('Use hover over text for menu item (requireTitle)', false),
      onClick: (0, _addonActions.action)('onClick'),
      hasDivider: (0, _addonKnobs.boolean)('Has divider (hasDivider)', false),
      isDelete: (0, _addonKnobs.boolean)('Is delete (isDelete)', false)
    };
  }
};
_OverflowMenu.OverflowMenu.displayName = 'OverflowMenu';
var _default = {
  title: 'Components/OverflowMenu',
  decorators: [_addonKnobs.withKnobs],
  component: _OverflowMenu.OverflowMenu,
  subcomponents: {
    OverflowMenuItem: _OverflowMenuItem.default
  },
  parameters: {
    docs: {
      page: _OverflowMenu2.default
    }
  }
};
exports.default = _default;

var _Default = function _Default() {
  return /*#__PURE__*/_react.default.createElement(_OverflowMenu.OverflowMenu, null, /*#__PURE__*/_react.default.createElement(_OverflowMenuItem.default, {
    itemText: "Stop app"
  }), /*#__PURE__*/_react.default.createElement(_OverflowMenuItem.default, {
    itemText: "Restart app"
  }), /*#__PURE__*/_react.default.createElement(_OverflowMenuItem.default, {
    itemText: "Rename app"
  }), /*#__PURE__*/_react.default.createElement(_OverflowMenuItem.default, {
    itemText: "Edit routes and access",
    requireTitle: true
  }), /*#__PURE__*/_react.default.createElement(_OverflowMenuItem.default, {
    hasDivider: true,
    isDelete: true,
    itemText: "Delete app"
  }));
};

exports._Default = _Default;
_Default.story = {
  name: 'Overflow Menu'
};

var RenderCustomIcon = function RenderCustomIcon() {
  return /*#__PURE__*/_react.default.createElement(_OverflowMenu.OverflowMenu, {
    renderIcon: _iconsReact.Filter16
  }, /*#__PURE__*/_react.default.createElement(_OverflowMenuItem.default, {
    itemText: "Filter A"
  }), /*#__PURE__*/_react.default.createElement(_OverflowMenuItem.default, {
    itemText: "Filter B"
  }));
};

exports.RenderCustomIcon = RenderCustomIcon;

var Playground = function Playground() {
  return /*#__PURE__*/_react.default.createElement(_OverflowMenu.OverflowMenu, props.menu(), /*#__PURE__*/_react.default.createElement(_OverflowMenuItem.default, _extends({}, props.menuItem(), {
    itemText: "Option 1"
  })), /*#__PURE__*/_react.default.createElement(_OverflowMenuItem.default, _extends({}, props.menuItem(), {
    itemText: "Option 2 is an example of a really long string and how we recommend handling this",
    requireTitle: true,
    title: "Custom tooltip title"
  })), /*#__PURE__*/_react.default.createElement(_OverflowMenuItem.default, _extends({}, props.menuItem(), {
    itemText: "Option 3"
  })), /*#__PURE__*/_react.default.createElement(_OverflowMenuItem.default, _extends({}, props.menuItem(), {
    itemText: "Option 4"
  })), /*#__PURE__*/_react.default.createElement(_OverflowMenuItem.default, _extends({}, props.menuItem(), {
    requireTitle: true,
    itemText: "Danger option",
    hasDivider: true,
    isDelete: true
  })));
};

exports.Playground = Playground;