"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _classnames2 = _interopRequireDefault(require("classnames"));

var _iconsReact = require("@carbon/icons-react");

var _carbonComponents = require("carbon-components");

var _Button = _interopRequireDefault(require("../Button"));

var _excluded = ["className", "onChange", "totalItems", "itemsShown", "page", "loop", "translateWithId"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var prefix = _carbonComponents.settings.prefix;
var translationIds = {
  'carbon.pagination-nav.next': 'Next',
  'carbon.pagination-nav.previous': 'Previous',
  'carbon.pagination-nav.item': 'Page',
  'carbon.pagination-nav.active': 'Active',
  'carbon.pagination-nav.of': 'of'
};

function translateWithId(messageId) {
  return translationIds[messageId];
} // https://reactjs.org/docs/hooks-faq.html#how-to-get-the-previous-props-or-state


function usePrevious(value) {
  var ref = (0, _react.useRef)();
  (0, _react.useEffect)(function () {
    ref.current = value;
  });
  return ref.current;
}

function getCuts(page, totalItems, itemsThatFit) {
  var splitPoint = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;

  if (itemsThatFit >= totalItems) {
    return {
      front: 0,
      back: 0
    };
  }

  var split = splitPoint || Math.ceil(itemsThatFit / 2) - 1;
  var frontHidden = page + 1 - split;
  var backHidden = totalItems - page - (itemsThatFit - split) + 1;

  if (frontHidden <= 1) {
    backHidden -= frontHidden <= 0 ? Math.abs(frontHidden) + 1 : 0;
    frontHidden = 0;
  }

  if (backHidden <= 1) {
    frontHidden -= backHidden <= 0 ? Math.abs(backHidden) + 1 : 0;
    backHidden = 0;
  }

  return {
    front: frontHidden,
    back: backHidden
  };
}

function DirectionButton(_ref) {
  var direction = _ref.direction,
      label = _ref.label,
      disabled = _ref.disabled,
      onClick = _ref.onClick;
  var icon = direction === 'forward' ? _iconsReact.CaretRight16 : _iconsReact.CaretLeft16;
  return /*#__PURE__*/_react.default.createElement("li", {
    className: "".concat(prefix, "--pagination-nav__list-item")
  }, /*#__PURE__*/_react.default.createElement(_Button.default, {
    disabled: disabled,
    renderIcon: icon,
    kind: "ghost",
    hasIconOnly: true,
    iconDescription: label,
    tooltipAlignment: "center",
    tooltipPosition: "bottom",
    onClick: onClick
  }));
}

function PaginationItem(_ref2) {
  var page = _ref2.page,
      isActive = _ref2.isActive,
      onClick = _ref2.onClick,
      _ref2$translateWithId = _ref2.translateWithId,
      t = _ref2$translateWithId === void 0 ? translateWithId : _ref2$translateWithId;
  var itemLabel = t('carbon.pagination-nav.item');
  return /*#__PURE__*/_react.default.createElement("li", {
    className: "".concat(prefix, "--pagination-nav__list-item")
  }, /*#__PURE__*/_react.default.createElement("button", {
    type: "button",
    className: (0, _classnames2.default)("".concat(prefix, "--pagination-nav__page"), _defineProperty({}, "".concat(prefix, "--pagination-nav__page--active"), isActive)),
    onClick: onClick,
    "data-page": page,
    "aria-current": isActive ? 'page' : null
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "".concat(prefix, "--pagination-nav__accessibility-label")
  }, isActive ? "".concat(t('carbon.pagination-nav.active'), ", ").concat(itemLabel) : itemLabel), page));
}

function PaginationOverflow(_ref3) {
  var fromIndex = _ref3.fromIndex,
      count = _ref3.count,
      onSelect = _ref3.onSelect,
      _ref3$translateWithId = _ref3.translateWithId,
      t = _ref3$translateWithId === void 0 ? translateWithId : _ref3$translateWithId;

  if (count > 1) {
    return /*#__PURE__*/_react.default.createElement("li", {
      className: "".concat(prefix, "--pagination-nav__list-item")
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "".concat(prefix, "--pagination-nav__select")
    }, /*#__PURE__*/_react.default.createElement("select", {
      className: "".concat(prefix, "--pagination-nav__page ").concat(prefix, "--pagination-nav__page--select"),
      "aria-label": "Select ".concat(t('carbon.pagination-nav.item'), " number"),
      onChange: function onChange(e) {
        var index = Number(e.target.value);
        onSelect(index);
      }
    }, /*#__PURE__*/_react.default.createElement("option", {
      value: "",
      hidden: true
    }), _toConsumableArray(Array(count)).map(function (e, i) {
      return /*#__PURE__*/_react.default.createElement("option", {
        value: (fromIndex + i).toString(),
        "data-page": fromIndex + i + 1,
        key: "overflow-".concat(fromIndex + i)
      }, fromIndex + i + 1);
    })), /*#__PURE__*/_react.default.createElement("div", {
      className: "".concat(prefix, "--pagination-nav__select-icon-wrapper")
    }, /*#__PURE__*/_react.default.createElement(_iconsReact.OverflowMenuHorizontal16, {
      className: "".concat(prefix, "--pagination-nav__select-icon")
    }))));
  }

  if (count === 1) {
    return /*#__PURE__*/_react.default.createElement(PaginationItem, {
      page: fromIndex + 1,
      translateWithId: t,
      onClick: function onClick() {
        onSelect(fromIndex);
      }
    });
  }

  return null;
}

var PaginationNav = /*#__PURE__*/_react.default.forwardRef(function PaginationNav(_ref4, ref) {
  var className = _ref4.className,
      _ref4$onChange = _ref4.onChange,
      onChange = _ref4$onChange === void 0 ? function () {} : _ref4$onChange,
      totalItems = _ref4.totalItems,
      _ref4$itemsShown = _ref4.itemsShown,
      itemsShown = _ref4$itemsShown === void 0 ? 10 : _ref4$itemsShown,
      _ref4$page = _ref4.page,
      page = _ref4$page === void 0 ? 0 : _ref4$page,
      _ref4$loop = _ref4.loop,
      loop = _ref4$loop === void 0 ? false : _ref4$loop,
      _ref4$translateWithId = _ref4.translateWithId,
      t = _ref4$translateWithId === void 0 ? translateWithId : _ref4$translateWithId,
      rest = _objectWithoutProperties(_ref4, _excluded);

  var _useState = (0, _react.useState)(page),
      _useState2 = _slicedToArray(_useState, 2),
      currentPage = _useState2[0],
      setCurrentPage = _useState2[1];

  var _useState3 = (0, _react.useState)(itemsShown >= 4 ? itemsShown : 4),
      _useState4 = _slicedToArray(_useState3, 2),
      itemsThatFit = _useState4[0],
      setItemsThatFit = _useState4[1];

  var _useState5 = (0, _react.useState)(getCuts(currentPage, totalItems, itemsThatFit)),
      _useState6 = _slicedToArray(_useState5, 2),
      cuts = _useState6[0],
      setCuts = _useState6[1];

  var prevPage = usePrevious(currentPage);

  function jumpToItem(index) {
    if (index >= 0 && index < totalItems) {
      setCurrentPage(index);
      onChange(index);
    }
  }

  function jumpToNext() {
    var nextIndex = currentPage + 1;

    if (nextIndex >= totalItems) {
      if (loop) {
        jumpToItem(0);
      }
    } else {
      jumpToItem(nextIndex);
    }
  }

  function jumpToPrevious() {
    var previousIndex = currentPage - 1;

    if (previousIndex < 0) {
      if (loop) {
        jumpToItem(totalItems - 1);
      }
    } else {
      jumpToItem(previousIndex);
    }
  }

  function pageWouldBeHidden(page) {
    var startOffset = itemsThatFit <= 4 && page > 1 ? 0 : 1;
    var wouldBeHiddenInFront = page >= startOffset && page <= cuts.front;
    var wouldBeHiddenInBack = page >= totalItems - cuts.back - 1 && page <= totalItems - 2;
    return wouldBeHiddenInFront || wouldBeHiddenInBack;
  } // jump to new page if props.page is updated


  (0, _react.useEffect)(function () {
    setCurrentPage(page);
  }, [page]); // re-calculate cuts if props.totalItems or props.itemsShown change

  (0, _react.useEffect)(function () {
    setItemsThatFit(itemsShown >= 4 ? itemsShown : 4);
    setCuts(getCuts(currentPage, totalItems, itemsShown));
  }, [totalItems, itemsShown]); // eslint-disable-line react-hooks/exhaustive-deps
  // update cuts if necessary whenever currentPage changes

  (0, _react.useEffect)(function () {
    if (pageWouldBeHidden(currentPage)) {
      var delta = currentPage - prevPage || 0;

      if (delta > 0) {
        var splitPoint = itemsThatFit - 3;
        setCuts(getCuts(currentPage, totalItems, itemsThatFit, splitPoint));
      } else {
        var _splitPoint = itemsThatFit > 4 ? 2 : 1;

        setCuts(getCuts(currentPage, totalItems, itemsThatFit, _splitPoint));
      }
    }
  }, [currentPage]); // eslint-disable-line react-hooks/exhaustive-deps

  var classNames = (0, _classnames2.default)("".concat(prefix, "--pagination-nav"), className);
  var backwardButtonDisabled = !loop && currentPage === 0;
  var forwardButtonDisabled = !loop && currentPage === totalItems - 1;
  var startOffset = itemsThatFit <= 4 && currentPage > 1 ? 0 : 1;
  return /*#__PURE__*/_react.default.createElement("nav", _extends({
    className: classNames,
    ref: ref
  }, rest, {
    "aria-label": "pagination"
  }), /*#__PURE__*/_react.default.createElement("ul", {
    className: "".concat(prefix, "--pagination-nav__list")
  }, /*#__PURE__*/_react.default.createElement(DirectionButton, {
    direction: "backward",
    label: t('carbon.pagination-nav.previous'),
    disabled: backwardButtonDisabled,
    onClick: jumpToPrevious
  }), // render first item if at least 5 items can be displayed or
  // 4 items can be displayed and the current page is either 0 or 1
  (itemsThatFit >= 5 || itemsThatFit <= 4 && currentPage <= 1) && /*#__PURE__*/_react.default.createElement(PaginationItem, {
    page: 1,
    translateWithId: t,
    isActive: currentPage === 0,
    onClick: function onClick() {
      jumpToItem(0);
    }
  }), /*#__PURE__*/_react.default.createElement(PaginationOverflow, {
    fromIndex: startOffset,
    count: cuts.front,
    onSelect: jumpToItem
  }), // render items between overflows
  _toConsumableArray(Array(totalItems)).map(function (e, i) {
    return i;
  }).slice(startOffset + cuts.front, (1 + cuts.back) * -1).map(function (item) {
    return /*#__PURE__*/_react.default.createElement(PaginationItem, {
      key: "item-".concat(item),
      page: item + 1,
      translateWithId: t,
      isActive: currentPage === item,
      onClick: function onClick() {
        jumpToItem(item);
      }
    });
  }), /*#__PURE__*/_react.default.createElement(PaginationOverflow, {
    fromIndex: totalItems - cuts.back - 1,
    count: cuts.back,
    onSelect: jumpToItem
  }), // render last item unless there is only one in total
  totalItems > 1 && /*#__PURE__*/_react.default.createElement(PaginationItem, {
    page: totalItems,
    translateWithId: t,
    isActive: currentPage === totalItems - 1,
    onClick: function onClick() {
      jumpToItem(totalItems - 1);
    }
  }), /*#__PURE__*/_react.default.createElement(DirectionButton, {
    direction: "forward",
    label: t('carbon.pagination-nav.next'),
    disabled: forwardButtonDisabled,
    onClick: jumpToNext
  })), /*#__PURE__*/_react.default.createElement("div", {
    "aria-live": "polite",
    "aria-atomic": "true",
    className: "".concat(prefix, "--pagination-nav__accessibility-label")
  }, "".concat(t('carbon.pagination-nav.item'), " ").concat(currentPage + 1, " ").concat(t('carbon.pagination-nav.of'), " ").concat(totalItems)));
});

DirectionButton.propTypes = {
  /**
   * The direction this button represents ("forward" or "backward").
   */
  direction: _propTypes.default.oneOf(['forward', 'backward']),

  /**
   * Whether or not the button should be disabled.
   */
  disabled: _propTypes.default.bool,

  /**
   * The label shown in the button's tooltip.
   */
  label: _propTypes.default.string,

  /**
   * The callback function called when the button is clicked.
   */
  onClick: _propTypes.default.func
};
PaginationItem.propTypes = {
  /**
   * Whether or not this is the currently active page.
   */
  isActive: _propTypes.default.bool,

  /**
   * The callback function called when the item is clicked.
   */
  onClick: _propTypes.default.func,

  /**
   * The page number this item represents.
   */
  page: _propTypes.default.number,

  /**
   * Specify a custom translation function that takes in a message identifier
   * and returns the localized string for the message
   */
  translateWithId: _propTypes.default.func
};
PaginationOverflow.propTypes = {
  /**
   * How many items to display in this overflow.
   */
  count: _propTypes.default.number,

  /**
   * From which index on this overflow should start displaying pages.
   */
  fromIndex: _propTypes.default.number,

  /**
   * The callback function called when the user selects a page from the overflow.
   */
  onSelect: _propTypes.default.func,

  /**
   * Specify a custom translation function that takes in a message identifier
   * and returns the localized string for the message
   */
  translateWithId: _propTypes.default.func
};
PaginationNav.displayName = 'PaginationNav';
PaginationNav.propTypes = {
  /**
   * Additional CSS class names.
   */
  className: _propTypes.default.string,

  /**
   * The number of items to be shown.
   */
  itemsShown: _propTypes.default.number,

  /**
   * Whether user should be able to loop through the items when reaching first / last.
   */
  loop: _propTypes.default.bool,

  /**
   * The callback function called when the current page changes.
   */
  onChange: _propTypes.default.func,

  /**
   * The current page.
   */
  page: _propTypes.default.number,

  /**
   * The total number of items.
   */
  totalItems: _propTypes.default.number,

  /**
   * Specify a custom translation function that takes in a message identifier
   * and returns the localized string for the message
   */
  translateWithId: _propTypes.default.func
};
var _default = PaginationNav;
exports.default = _default;