"use strict";

var _react = _interopRequireDefault(require("react"));

var _ProgressBar = _interopRequireDefault(require("./ProgressBar"));

var _react2 = require("@testing-library/react");

var _carbonComponents = require("carbon-components");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var prefix = _carbonComponents.settings.prefix;
describe('ProgressBar', function () {
  var props = {
    label: 'ProgressBar label'
  };
  var wrapper;
  beforeEach(function () {
    wrapper = (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_ProgressBar.default, props));
  });
  describe('renders as expected', function () {
    it('progress bar and label ids match', function () {
      var bar = wrapper.getByRole('progressbar');
      var label = wrapper.container.querySelector('span');
      expect(bar.getAttribute('aria-labelledby')).toBe(label.id);
    });
    it('renders helper text when passed', function () {
      var text = 'ProgressBar helper text';
      wrapper.rerender( /*#__PURE__*/_react.default.createElement(_ProgressBar.default, _extends({}, props, {
        helperText: text
      })));
      var helperText = wrapper.container.querySelector(".".concat(prefix, "--progress-bar__helper-text"));
      expect(helperText.textContent).toBe(text);
      expect(wrapper.getByRole('progressbar').getAttribute('aria-describedby')).toBe(helperText.id);
    });
    it('still renders accessible when hideLabel is passed', function () {
      wrapper.rerender( /*#__PURE__*/_react.default.createElement(_ProgressBar.default, _extends({}, props, {
        hideLabel: true
      })));
      var label = wrapper.container.querySelector('span');
      expect(label.textContent).toBe(props.label);
      expect(label.classList.contains("".concat(prefix, "--visually-hidden"))).toBe(true);
    });
    it('renders as indeterminate when no value is passed', function () {
      var bar = wrapper.getByRole('progressbar');
      expect(bar.getAttribute('aria-valuenow')).toBe(null);
      expect(bar.getAttribute('aria-valuemax')).toBe(null);
      expect(bar.getAttribute('aria-valuemin')).toBe(null);
      expect(wrapper.container.querySelector(".".concat(prefix, "--progress-bar")).classList.contains("".concat(prefix, "--progress-bar--indeterminate"))).toBe(true);
    });
    it('sets aria-valuenow correctly', function () {
      var value = 42;
      wrapper.rerender( /*#__PURE__*/_react.default.createElement(_ProgressBar.default, _extends({}, props, {
        value: value
      })));
      expect(wrapper.getByRole('progressbar').getAttribute('aria-valuenow')).toBe(value.toString());
    });
    it('sets aria-valuemax correctly', function () {
      var max = 84;
      wrapper.rerender( /*#__PURE__*/_react.default.createElement(_ProgressBar.default, _extends({}, props, {
        value: 0,
        max: max
      })));
      expect(wrapper.getByRole('progressbar').getAttribute('aria-valuemax')).toBe(max.toString());
    });
    it('supports additional css class names', function () {
      var className = 'some-class';
      wrapper.rerender( /*#__PURE__*/_react.default.createElement(_ProgressBar.default, _extends({}, props, {
        className: className
      })));
      expect(wrapper.container.querySelector(".".concat(prefix, "--progress-bar")).classList.contains(className)).toBe(true);
    });
  });
  describe('behaves as expected', function () {
    it('limits value to max', function () {
      var value = 200;
      var max = 50;
      wrapper.rerender( /*#__PURE__*/_react.default.createElement(_ProgressBar.default, _extends({}, props, {
        value: value,
        max: max
      })));
      expect(wrapper.getByRole('progressbar').getAttribute('aria-valuenow')).toBe(max.toString());
    });
    it('ensures a positive value', function () {
      var value = -10;
      wrapper.rerender( /*#__PURE__*/_react.default.createElement(_ProgressBar.default, _extends({}, props, {
        value: value
      })));
      expect(wrapper.getByRole('progressbar').getAttribute('aria-valuenow')).toBe('0');
    });
  });
});