"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _usePrefix = require("../../internal/usePrefix");

var _excluded = ["className", "type"];

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

// const tab = (
//   <li className={`${prefix}--tabs--scrollable__nav-item`}>
//     <div className={`${prefix}--tabs__nav-link`}>
//       <span></span>
//     </div>
//   </li>
// );
function Tab() {
  var prefix = (0, _usePrefix.usePrefix)();
  return /*#__PURE__*/_react.default.createElement("li", {
    className: "".concat(prefix, "--tabs--scrollable__nav-item")
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--tabs__nav-link")
  }, /*#__PURE__*/_react.default.createElement("span", null)));
}

function TabsSkeleton(_ref) {
  var className = _ref.className,
      type = _ref.type,
      rest = _objectWithoutProperties(_ref, _excluded);

  var prefix = (0, _usePrefix.usePrefix)();
  var tabClasses = (0, _classnames.default)(className, "".concat(prefix, "--tabs"), "".concat(prefix, "--skeleton"), "".concat(prefix, "--tabs--scrollable"), _defineProperty({}, "".concat(prefix, "--tabs--scrollable--container"), type === 'container'));
  return /*#__PURE__*/_react.default.createElement("div", _extends({
    className: tabClasses
  }, rest), /*#__PURE__*/_react.default.createElement("ul", {
    className: "".concat(prefix, "--tabs--scrollable__nav")
  }, Tab(), Tab(), Tab(), Tab(), Tab()));
}

TabsSkeleton.propTypes = {
  /**
   * Specify an optional className to add.
   */
  className: _propTypes.default.string,

  /**
   * Provide the type of Tab
   */
  type: _propTypes.default.oneOf(['', 'default', 'container'])
};
var _default = TabsSkeleton;
exports.default = _default;