"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.types = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _iconsReact = require("@carbon/icons-react");

var _setupGetInstanceId = _interopRequireDefault(require("../../tools/setupGetInstanceId"));

var _usePrefix = require("../../internal/usePrefix");

var _excluded = ["children", "className", "id", "type", "filter", "renderIcon", "title", "disabled", "onClose", "size"];

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var getInstanceId = (0, _setupGetInstanceId.default)();
var TYPES = {
  red: 'Red',
  magenta: 'Magenta',
  purple: 'Purple',
  blue: 'Blue',
  cyan: 'Cyan',
  teal: 'Teal',
  green: 'Green',
  gray: 'Gray',
  'cool-gray': 'Cool-Gray',
  'warm-gray': 'Warm-Gray',
  'high-contrast': 'High-Contrast'
};

var Tag = function Tag(_ref) {
  var _classNames;

  var children = _ref.children,
      className = _ref.className,
      id = _ref.id,
      type = _ref.type,
      filter = _ref.filter,
      CustomIconElement = _ref.renderIcon,
      title = _ref.title,
      disabled = _ref.disabled,
      onClose = _ref.onClose,
      size = _ref.size,
      other = _objectWithoutProperties(_ref, _excluded);

  var prefix = (0, _usePrefix.usePrefix)();
  var tagId = id || "tag-".concat(getInstanceId());
  var tagClasses = (0, _classnames.default)("".concat(prefix, "--tag"), className, (_classNames = {}, _defineProperty(_classNames, "".concat(prefix, "--tag--disabled"), disabled), _defineProperty(_classNames, "".concat(prefix, "--tag--filter"), filter), _defineProperty(_classNames, "".concat(prefix, "--tag--").concat(size), size), _defineProperty(_classNames, "".concat(prefix, "--tag--").concat(type), type), _defineProperty(_classNames, "".concat(prefix, "--tag--interactive"), other.onClick && !filter), _classNames));

  var handleClose = function handleClose(event) {
    if (onClose) {
      event.stopPropagation();
      onClose(event);
    }
  };

  if (filter) {
    return /*#__PURE__*/_react.default.createElement("div", _extends({
      className: tagClasses,
      "aria-label": title !== undefined ? "".concat(title, " ").concat(children) : "Clear filter ".concat(children),
      id: tagId
    }, other), /*#__PURE__*/_react.default.createElement("span", {
      className: "".concat(prefix, "--tag__label"),
      title: typeof children === 'string' ? children : null
    }, children !== null && children !== undefined ? children : TYPES[type]), /*#__PURE__*/_react.default.createElement("button", {
      type: "button",
      className: "".concat(prefix, "--tag__close-icon"),
      onClick: handleClose,
      disabled: disabled,
      "aria-labelledby": tagId,
      title: title
    }, /*#__PURE__*/_react.default.createElement(_iconsReact.Close16, null)));
  }

  var ComponentTag = other.onClick ? 'button' : 'div';
  return /*#__PURE__*/_react.default.createElement(ComponentTag, _extends({
    disabled: ComponentTag === 'button' ? disabled : null,
    className: tagClasses,
    id: tagId
  }, other), CustomIconElement ? /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--tag__custom-icon")
  }, /*#__PURE__*/_react.default.createElement(CustomIconElement, null)) : '', /*#__PURE__*/_react.default.createElement("span", {
    title: typeof children === 'string' ? children : null
  }, children !== null && children !== undefined ? children : TYPES[type]));
};

Tag.propTypes = {
  /**
   * Provide content to be rendered inside of a <Tag>
   */
  children: _propTypes.default.node,

  /**
   * Provide a custom className that is applied to the containing <span>
   */
  className: _propTypes.default.string,

  /**
   * Specify if the <Tag> is disabled
   */
  disabled: _propTypes.default.bool,

  /**
   * Determine if <Tag> is a filter/chip
   */
  filter: _propTypes.default.bool,

  /**
   * Specify the id for the tag.
   */
  id: _propTypes.default.string,

  /**
   * Click handler for filter tag close button.
   */
  onClose: _propTypes.default.func,

  /**
   * Optional prop to render a custom icon.
   * Can be a React component class
   */
  renderIcon: _propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.object]),

  /**
   * Specify the size of the Tag. Currently supports either `sm` or
   * 'md' (default) sizes.
   */
  size: _propTypes.default.oneOf(['sm', 'md']),

  /**
   * Text to show on clear filters
   */
  title: _propTypes.default.string,

  /**
   * Specify the type of the <Tag>
   */
  type: _propTypes.default.oneOf(Object.keys(TYPES))
};
var types = Object.keys(TYPES);
exports.types = types;
var _default = Tag;
exports.default = _default;