"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireWildcard(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _AriaPropTypes = require("../../prop-types/AriaPropTypes");

var _utils = require("./_utils");

var _usePrefix = require("../../internal/usePrefix");

var _excluded = ["expanded", "defaultExpanded", "isChildOfHeader", "aria-label", "aria-labelledby", "children", "onToggle", "className", "isFixedNav", "isRail", "isPersistent", "addFocusListeners", "addMouseListeners", "onOverlayClick"];

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

// TO-DO: comment back in when footer is added for rails
// import SideNavFooter from './SideNavFooter';
var SideNav = /*#__PURE__*/_react.default.forwardRef(function SideNav(props, ref) {
  var _cx, _cx2;

  var expandedProp = props.expanded,
      defaultExpanded = props.defaultExpanded,
      isChildOfHeader = props.isChildOfHeader,
      ariaLabel = props['aria-label'],
      ariaLabelledBy = props['aria-labelledby'],
      children = props.children,
      onToggle = props.onToggle,
      customClassName = props.className,
      isFixedNav = props.isFixedNav,
      isRail = props.isRail,
      isPersistent = props.isPersistent,
      addFocusListeners = props.addFocusListeners,
      addMouseListeners = props.addMouseListeners,
      onOverlayClick = props.onOverlayClick,
      other = _objectWithoutProperties(props, _excluded);

  var prefix = (0, _usePrefix.usePrefix)();

  var _useRef = (0, _react.useRef)(expandedProp !== undefined),
      controlled = _useRef.current;

  var _useState = (0, _react.useState)(defaultExpanded),
      _useState2 = _slicedToArray(_useState, 2),
      expandedState = _useState2[0],
      setExpandedState = _useState2[1];

  var _useState3 = (0, _react.useState)(defaultExpanded),
      _useState4 = _slicedToArray(_useState3, 2),
      expandedViaHoverState = _useState4[0],
      setExpandedViaHoverState = _useState4[1];

  var expanded = controlled ? expandedProp : expandedState;

  var handleToggle = function handleToggle(event) {
    var value = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : !expanded;

    if (!controlled) {
      setExpandedState(value);
    }

    if (onToggle) {
      onToggle(event, value);
    }

    if (controlled || isRail) {
      setExpandedViaHoverState(value);
    }
  };

  var accessibilityLabel = {
    'aria-label': ariaLabel,
    'aria-labelledby': ariaLabelledBy
  }; // TO-DO: comment back in when footer is added for rails
  // const assistiveText = expanded
  //   ? t('carbon.sidenav.state.open')
  //   : t('carbon.sidenav.state.closed');

  var className = (0, _classnames.default)((_cx = {}, _defineProperty(_cx, "".concat(prefix, "--side-nav"), true), _defineProperty(_cx, "".concat(prefix, "--side-nav--expanded"), expanded || expandedViaHoverState), _defineProperty(_cx, "".concat(prefix, "--side-nav--collapsed"), !expanded && isFixedNav), _defineProperty(_cx, "".concat(prefix, "--side-nav--rail"), isRail), _defineProperty(_cx, customClassName, !!customClassName), _defineProperty(_cx, "".concat(prefix, "--side-nav--ux"), isChildOfHeader), _defineProperty(_cx, "".concat(prefix, "--side-nav--hidden"), !isPersistent), _cx));
  var overlayClassName = (0, _classnames.default)((_cx2 = {}, _defineProperty(_cx2, "".concat(prefix, "--side-nav__overlay"), true), _defineProperty(_cx2, "".concat(prefix, "--side-nav__overlay-active"), expanded || expandedViaHoverState), _cx2));
  var childrenToRender = children; // if a rail, pass the expansion state as a prop, so children can update themselves to match

  if (isRail) {
    childrenToRender = _react.default.Children.map(children, function (child) {
      var _child$type;

      // if we are controlled, check for if we have hovered over or the expanded state, else just use the expanded state (uncontrolled)
      var currentExpansionState = controlled ? expandedViaHoverState || expanded : expanded; // avoid spreading `isSideNavExpanded` to non-Carbon UI Shell children

      return /*#__PURE__*/_react.default.cloneElement(child, _objectSpread({}, _utils.CARBON_SIDENAV_ITEMS.includes((_child$type = child.type) === null || _child$type === void 0 ? void 0 : _child$type.displayName) ? {
        isSideNavExpanded: currentExpansionState
      } : {}));
    });
  }

  var eventHandlers = {};

  if (addFocusListeners) {
    eventHandlers.onFocus = function (event) {
      if (!event.currentTarget.contains(event.relatedTarget)) {
        handleToggle(event, true);
      }
    };

    eventHandlers.onBlur = function (event) {
      if (!event.currentTarget.contains(event.relatedTarget)) {
        handleToggle(event, false);
      }
    };
  }

  if (addMouseListeners && isRail) {
    eventHandlers.onMouseEnter = function () {
      return handleToggle(true, true);
    };

    eventHandlers.onMouseLeave = function () {
      return handleToggle(false, false);
    };
  }

  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isFixedNav ? null :
  /*#__PURE__*/
  // eslint-disable-next-line jsx-a11y/click-events-have-key-events, jsx-a11y/no-static-element-interactions
  _react.default.createElement("div", {
    className: overlayClassName,
    onClick: onOverlayClick
  }), /*#__PURE__*/_react.default.createElement("nav", _extends({
    "aria-hidden": !expanded,
    ref: ref,
    className: "".concat(prefix, "--side-nav__navigation ").concat(className)
  }, accessibilityLabel, eventHandlers, other), childrenToRender));
});

SideNav.displayName = 'SideNav';
SideNav.defaultProps = {
  // TO-DO: comment back in when footer is added for rails
  // translateById: (id) => {
  //   const translations = {
  //     'carbon.sidenav.state.open': 'Close',
  //     'carbon.sidenav.state.closed': 'Open',
  //   };
  //   return translations[id];
  // },
  defaultExpanded: false,
  isChildOfHeader: true,
  isFixedNav: false,
  isPersistent: true,
  addFocusListeners: true,
  addMouseListeners: true
};
SideNav.propTypes = _objectSpread(_objectSpread({}, _AriaPropTypes.AriaLabelPropType), {}, {
  /**
   * Specify whether focus and blur listeners are added. They are by default.
   */
  addFocusListeners: _propTypes.default.bool,

  /**
   * Specify whether mouse entry/exit listeners are added. They are by default.
   */
  addMouseListeners: _propTypes.default.bool,

  /**
   * Optionally provide a custom class to apply to the underlying `<li>` node
   */
  className: _propTypes.default.string,

  /**
   * If `true`, the SideNav will be open on initial render.
   */
  defaultExpanded: _propTypes.default.bool,

  /**
   * If `true`, the SideNav will be expanded, otherwise it will be collapsed.
   * Using this prop causes SideNav to become a controled component.
   */
  expanded: _propTypes.default.bool,

  /**
   * Optionally provide a custom class to apply to the underlying `<li>` node
   */
  isChildOfHeader: _propTypes.default.bool,

  /**
   * Specify if sideNav is standalone
   */
  isFixedNav: _propTypes.default.bool,

  /**
   * Specify if the sideNav will be persistent above the lg breakpoint
   */
  isPersistent: _propTypes.default.bool,

  /**
   * Optional prop to display the side nav rail.
   */
  isRail: _propTypes.default.bool,

  /**
   * An optional listener that is called when the SideNav overlay is clicked
   *
   * @param {object} event
   */
  onOverlayClick: _propTypes.default.func,

  /**
   * An optional listener that is called when an event that would cause
   * toggling the SideNav occurs.
   *
   * @param {object} event
   * @param {boolean} value
   */
  onToggle: _propTypes.default.func,

  /**
   * Provide a custom function for translating all message ids within this
   * component. This function will take in two arguments: the mesasge Id and the
   * state of the component. From this, you should return a string representing
   * the label you want displayed or read by screen readers.
   */
  translateById: _propTypes.default.func
});
var _default = SideNav;
exports.default = _default;