/**
 * Hints to improve visualization of table cells
 *
 */
declare const enum CellShould {
    HideWithSidecar = "hide-with-sidecar",
    HideWhenNarrow = "hide-with-narrow-window",
    ElideWhenNarrow = "elide-with-narrow-window",
    BeGrayish = "sub-text",
    BeHidden = "hide",
    HaveGreenBadge = "green-background",
    HaveYellowBadge = "yellow-background",
    HaveRedBadge = "red-background",
    HaveGrayBadge = "gray-background"
}
/** Check whether the cell hints include a hint to display as badge */
export declare function cellShouldHaveBadge(hints: CellShould | CellShould[]): CellShould | void;
export default CellShould;
