"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rowWith = rowWith;
exports.unifyHeaders = unifyHeaders;
exports.unifyRow = unifyRow;
exports.unifyRows = unifyRows;
exports.unifyTable = unifyTable;
exports.standardStatusHeader = exports.Status = exports.Kind = void 0;

var _trafficLight = _interopRequireWildcard(require("../../../lib/model/traffic-light"));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/** Do not i18n! */
const Kind = 'Kind';
exports.Kind = Kind;
const Status = 'Status';
exports.Status = Status;
const standardStatusHeader = {
  name: 'Name',
  attributes: [{
    key: Kind,
    value: Kind
  }, {
    key: Status,
    value: Status
  }]
};
exports.standardStatusHeader = standardStatusHeader;

function rowWith(name, kind, status, trafficLight, originalRow, extraAttrs = []) {
  const overlay = {
    name,
    attributes: extraAttrs.concat([{
      key: Kind,
      value: kind
    }, {
      key: Status,
      value: status,
      tag: 'badge',
      css: trafficLight
    }])
  };

  if (originalRow) {
    return Object.assign({}, originalRow, overlay);
  } else {
    return overlay;
  }
} // eslint-disable-next-line @typescript-eslint/no-unused-vars


function unifyHeaders(headers) {
  return standardStatusHeader;
}

function getFromLabel(object, field) {
  return object.metadata && object.metadata.labels ? object.metadata.labels[field] : undefined;
}

function getFromSelector(object, field) {
  if (object.spec && object.spec.selector && object.spec.selector.matchLabels) {
    return object.spec.selector.matchLabels[field];
  }
}

function unifyRow(row, kind) {
  const name = row.name;
  const badgeColumnIdx = row.attributes.findIndex(_ => _.tag === 'badge');
  const status = badgeColumnIdx >= 0 ? row.attributes[badgeColumnIdx].value : 'Unknown';
  const trafficLight = badgeColumnIdx >= 0 ? (0, _trafficLight.toTrafficLight)(row.attributes[badgeColumnIdx].css) : _trafficLight.default.Gray;
  const extraAttrs = [];
  const tier = row.object ? getFromLabel(row.object, 'tier') || getFromLabel(row.object, 'app.kubernetes.io/component') || getFromSelector(row.object, 'tier') : '';
  extraAttrs.push({
    key: 'Tier',
    value: tier
  });
  const app = row.object ? getFromLabel(row.object, 'app') || getFromLabel(row.object, 'app.kubernetes.io/name') || getFromSelector(row.object, 'app') : '';
  extraAttrs.push({
    key: 'Application',
    value: app
  });
  return rowWith(name, kind, status, trafficLight, row, extraAttrs);
}

function unifyRows(rows, kinds) {
  return rows.map((row, idx) => {
    const kind = Array.isArray(kinds) ? kinds[idx] : kinds;
    return unifyRow(row, kind);
  });
}

function unifyTable(table, kind) {
  const overlay = {
    header: unifyHeaders([table.header]),
    body: unifyRows(table.body, kind)
  };
  return Object.assign({}, table, overlay);
}