/*
 * Copyright 2019 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { exec } from './exec';
import { doGetAsEntity, getFlags as flags } from './get';
import { isUsage, doHelp } from '../../lib/util/help';
import { commandWithoutResource } from '../../lib/util/util';
/**
 * describe -> get
 *
 */
function prepareArgsForDescribe(args) {
    return `${args.command.replace(/(k|kubectl|oc)(\s+)describe(\s+)/, '$1$2get$3')} -o yaml`;
}
const doDescribe = (command) => function (args) {
    return __awaiter(this, void 0, void 0, function* () {
        if (isUsage(args)) {
            return doHelp(command, args);
        }
        else if (commandWithoutResource(args)) {
            return exec(args, undefined, command);
        }
        else {
            // first, we do the raw exec of the given command
            const response = yield exec(args, prepareArgsForDescribe, command);
            return doGetAsEntity(args, response);
        }
    });
};
/** Register a command listener */
export function describer(registrar, command, cli = command) {
    registrar.listen(`/${command}/describe`, doDescribe(cli), flags);
}
export default (registrar) => {
    describer(registrar, 'kubectl');
    describer(registrar, 'k', 'kubectl');
};
//# sourceMappingURL=describe.js.map