"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTabState = getTabState;
exports.default = _default;

var _debug = _interopRequireDefault(require("debug"));

var _core = require("@kui-shell/core");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2021 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const debug = (0, _debug.default)('plugins/bash-like/tab-state');
const name = 'plugins/plugin-bash-like';
const apiVersion = 'v1';

function getTabState(tab, key) {
  return tab.getState(name, apiVersion, key);
}

function setTabState(tab, key, value) {
  tab.setState(name, apiVersion, key, value);
}

const capture = tab => {
  setTabState(tab, 'env', Object.assign({}, process.env));
  setTabState(tab, 'cwd', (0, _core.cwd)());
  debug('captured tab state', tab.uuid, getTabState(tab, 'cwd'));
};

const restore = tab => {
  const env = getTabState(tab, 'env');
  const cwd = getTabState(tab, 'cwd');
  debug('restoring state', tab.uuid, cwd);
  process.env = env;

  if (cwd !== undefined) {
    if ((0, _core.inBrowser)() || process.env.VIRTUAL_CWD) {
      debug('changing cwd', process.env.PWD, cwd);
      process.env.PWD = cwd;
    } else {
      debug('changing cwd', process.cwd(), cwd);
      process.chdir(cwd);
    }
  }
};

const switchTo = (currentTabState, nextTabState) => {
  capture(currentTabState);
  restore(nextTabState);
};

function _default() {
  return (0, _core.registerTabState)({
    name,
    apiVersion,
    capture,
    restore,
    switchTo
  });
}