/**
 * Match strings that look like this:
 *   k1=v1
 *   k2=v2
 *    ...
 *
 * and capture the `(k1,v1)` pairs. The return value will be:
 *   `[ { name: 'k1', attributes: [ { name: 'v1' } ] }, ... ]`
 */
interface Attr {
    name: string;
    value: string;
    css: string;
}
interface Pair {
    type: string;
    name: string;
    onclick: boolean;
    attributes: Attr[];
}
declare const _default: (str: string) => Pair[] | void;
export default _default;
