"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isCommandHandlerWithEvents = isCommandHandlerWithEvents;
exports.ExecType = void 0;

/*
 * Copyright 2019 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * "top-level", meaning the user hit enter in the CLI,
 * "click-handler", meaning that the user clicked on a UI element
 * "nested", meaning that some evaluator uses the repl in its internal implementation
 *
 */
var ExecType;
exports.ExecType = ExecType;

(function (ExecType) {
  ExecType[ExecType["TopLevel"] = 0] = "TopLevel";
  ExecType[ExecType["ClickHandler"] = 1] = "ClickHandler";
  ExecType[ExecType["Nested"] = 2] = "Nested";
  ExecType[ExecType["Rerun"] = 3] = "Rerun";
})(ExecType || (exports.ExecType = ExecType = {}));

function isCommandHandlerWithEvents(evaluator) {
  const handler = evaluator;
  return handler.options !== undefined;
}