import { CodedError } from '../models/errors';
import { ExecOptions } from '../models/execOptions';
import { Evaluator, EvaluatorArgs, KResponse, ParsedOptions } from '../models/command';
import { MixedResponse } from '../models/entity';
/**
 * repl.exec, and the family repl.qexec, repl.pexec, etc. are all
 * backed by an implementation of this interface
 *
 */
export interface Executor {
    name: string;
    exec<T extends KResponse, O extends ParsedOptions>(commandUntrimmed: string, execOptions: ExecOptions): Promise<T | CodedError<number> | HTMLElement | MixedResponse>;
}
/**
 * Apply the given evaluator to the given arguments
 *
 */
export interface ReplEval {
    name: string;
    apply<T extends KResponse, O extends ParsedOptions>(commandUntrimmed: string, execOptions: ExecOptions, evaluator: Evaluator<T, O>, args: EvaluatorArgs<O>): T | Promise<T>;
}
/**
 * Directly apply the given evaluator to the given arguments. This is
 * the default evaluator implementation.
 *
 */
export declare class DirectReplEval implements ReplEval {
    name: string;
    apply<T extends KResponse, O extends ParsedOptions>(commandUntrimmed: string, execOptions: ExecOptions, evaluator: Evaluator<T, O>, args: EvaluatorArgs<O>): T | Promise<T>;
}
