/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import ButtonSet from '../ButtonSet';
import { shallow } from 'enzyme';
import { settings } from 'carbon-components';
var prefix = settings.prefix;
describe('ButtonSet', function () {
  var wrapper;
  beforeEach(function () {
    wrapper = shallow( /*#__PURE__*/React.createElement(ButtonSet, {
      className: "extra-class"
    }));
  });
  it('should render empty set as expected', function () {
    expect(wrapper.find('.child').length).toBe(0);
  });
  it('should render nonempty set as expected', function () {
    wrapper = shallow( /*#__PURE__*/React.createElement(ButtonSet, null, /*#__PURE__*/React.createElement("div", {
      className: "test-child"
    }), /*#__PURE__*/React.createElement("div", {
      className: "test-child"
    })));
    expect(wrapper.find('.test-child').length).toBe(2);
  });
  it('should render wrapper as expected', function () {
    expect(wrapper.length).toBe(1);
  });
  it('should have the expected classes in a horizontal set', function () {
    expect(wrapper.hasClass("".concat(prefix, "--btn-set"))).toEqual(true);
  });
  it('should have the expected classes in a vertical set', function () {
    wrapper.setProps({
      stacked: true
    });
    expect(wrapper.hasClass("".concat(prefix, "--btn-set"))).toEqual(true);
    expect(wrapper.hasClass("".concat(prefix, "--btn-set--stacked"))).toEqual(true);
  });
});