import React from 'react';
import { shallow, mount } from 'enzyme';
import Button from '../../Button';
import { ModalFooter } from './ModalFooter';
import InlineLoading from '../../InlineLoading';
import { settings } from 'carbon-components';
var prefix = settings.prefix;
describe('<ModalFooter />', function () {
  describe('Renders as expected', function () {
    var wrapper = mount( /*#__PURE__*/React.createElement(ModalFooter, {
      className: "extra-class"
    }, /*#__PURE__*/React.createElement("p", null, "Test")));
    it('renders children as expected', function () {
      expect(wrapper.find('p').length).toBe(1);
    });
    it('renders wrapper as expected', function () {
      expect(wrapper.length).toBe(1);
    });
    it('renders extra classes passed in via className', function () {
      expect(wrapper.hasClass('extra-class')).toEqual(true);
    });
  });
  describe('Should render buttons only if appropriate prop passed in', function () {
    var wrapper = shallow( /*#__PURE__*/React.createElement(ModalFooter, {
      className: "extra-class"
    }, /*#__PURE__*/React.createElement("p", null, "Test")));
    var primaryWrapper = shallow( /*#__PURE__*/React.createElement(ModalFooter, {
      primaryButtonText: "test"
    }));
    var secondaryWrapper = mount( /*#__PURE__*/React.createElement(ModalFooter, {
      secondaryButtonText: "test"
    }));
    var multipleSecondaryWrapper = mount( /*#__PURE__*/React.createElement(ModalFooter, {
      secondaryButtons: [{
        buttonText: /*#__PURE__*/React.createElement(InlineLoading, null),
        onClick: jest.fn()
      }, {
        buttonText: 'Cancel',
        onClick: jest.fn()
      }]
    }));
    it('does not render primary button if no primary text', function () {
      expect(wrapper.find(".".concat(prefix, "--btn--primary")).exists()).toBe(false);
    });
    it('does not render secondary button if no secondary text', function () {
      expect(wrapper.find(".".concat(prefix, "--btn--secondary")).exists()).toBe(false);
    });
    it('renders primary button if primary text', function () {
      var buttonComponent = primaryWrapper.find(Button);
      expect(buttonComponent.exists()).toBe(true);
      expect(buttonComponent.props().kind).toBe('primary');
    });
    it('renders primary button if secondary text', function () {
      var buttonComponent = secondaryWrapper.find(Button);
      expect(buttonComponent.exists()).toBe(true);
      expect(buttonComponent.props().kind).toBe('secondary');
    });
    it('correctly renders multiple secondary buttons', function () {
      var buttonComponents = multipleSecondaryWrapper.find(Button);
      expect(buttonComponents.length).toEqual(2);
      expect(buttonComponents.at(0).props().kind).toBe('secondary');
      expect(buttonComponents.at(1).props().kind).toBe('secondary');
    });
  });
  describe('Should render the appropriate buttons when `danger` prop is true', function () {
    var primaryWrapper = shallow( /*#__PURE__*/React.createElement(ModalFooter, {
      primaryButtonText: "test",
      danger: true
    }));
    var secondaryWrapper = mount( /*#__PURE__*/React.createElement(ModalFooter, {
      secondaryButtonText: "test",
      danger: true
    }));
    var multipleSecondaryWrapper = mount( /*#__PURE__*/React.createElement(ModalFooter, {
      secondaryButtons: [{
        buttonText: /*#__PURE__*/React.createElement(InlineLoading, null),
        onClick: jest.fn()
      }, {
        buttonText: 'Cancel',
        onClick: jest.fn()
      }]
    }));
    it('renders danger button if primary text && danger', function () {
      var buttonComponent = primaryWrapper.find(Button);
      expect(buttonComponent.exists()).toBe(true);
      expect(buttonComponent.props().kind).toBe('danger');
    });
    it('renders secondary button if secondary text && danger', function () {
      var buttonComponent = secondaryWrapper.find(Button);
      expect(buttonComponent.exists()).toBe(true);
      expect(buttonComponent.prop('kind')).toBe('secondary');
    });
    it('correctly renders multiple secondary buttons', function () {
      var buttonComponents = multipleSecondaryWrapper.find(Button);
      expect(buttonComponents.length).toEqual(2);
      expect(buttonComponents.at(0).props().kind).toBe('secondary');
      expect(buttonComponents.at(1).props().kind).toBe('secondary');
    });
  });
});