import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["range", "id", "className"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React from 'react';
import cx from 'classnames';
import { usePrefix } from '../../internal/usePrefix';

var DatePickerSkeleton = function DatePickerSkeleton(_ref) {
  var range = _ref.range,
      id = _ref.id,
      className = _ref.className,
      rest = _objectWithoutProperties(_ref, _excluded);

  var prefix = usePrefix();
  var dateInput = /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--date-picker-container")
  },
  /*#__PURE__*/

  /* eslint-disable jsx-a11y/label-has-for,jsx-a11y/label-has-associated-control */
  React.createElement("label", {
    className: "".concat(prefix, "--label"),
    htmlFor: id
  }), /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--date-picker__input ").concat(prefix, "--skeleton")
  }));

  if (range) {
    return /*#__PURE__*/React.createElement("div", {
      className: "".concat(prefix, "--form-item")
    }, /*#__PURE__*/React.createElement("div", _extends({
      className: cx("".concat(prefix, "--date-picker"), "".concat(prefix, "--date-picker--range"), "".concat(prefix, "--skeleton"), className)
    }, rest), dateInput, dateInput));
  }

  return /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--form-item")
  }, /*#__PURE__*/React.createElement("div", _extends({
    className: cx("".concat(prefix, "--date-picker"), "".concat(prefix, "--date-picker--short"), "".concat(prefix, "--date-picker--simple"), "".concat(prefix, "--skeleton"), className)
  }, rest), dateInput));
};

DatePickerSkeleton.propTypes = {
  /**
   * Specify an optional className to add.
   */
  className: PropTypes.string,

  /**
   * Specify the id to add.
   */
  id: PropTypes.string,

  /**
   * Specify whether the skeleton should be of range date picker.
   */
  range: PropTypes.bool
};
export default DatePickerSkeleton;