/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import './Layer-story.scss';
import React from 'react';
import { Layer } from '../../Layer';
import mdx from './Layer.mdx';
export default {
  title: 'Components/Layer',
  component: Layer,
  parameters: {
    controls: {
      hideNoControlsWarning: true
    },
    docs: {
      page: mdx
    }
  },
  argTypes: {
    as: {
      table: {
        disable: true
      }
    },
    children: {
      table: {
        disable: true
      }
    },
    className: {
      table: {
        disable: true
      }
    }
  }
};
export var Default = function Default() {
  function TestComponent() {
    return /*#__PURE__*/React.createElement("div", {
      className: "example-layer-test-component"
    }, "Test component");
  }

  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(TestComponent, null), /*#__PURE__*/React.createElement(Layer, null, /*#__PURE__*/React.createElement(TestComponent, null), /*#__PURE__*/React.createElement(Layer, null, /*#__PURE__*/React.createElement(TestComponent, null))));
};