import _slicedToArray from "@babel/runtime/helpers/slicedToArray";

/**
 * Copyright IBM Corp. 2020
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React, { useState } from 'react';
import PropTypes from 'prop-types';
import { Checkmark16 } from '@carbon/icons-react';
import MenuOption from './MenuOption';

function MenuSelectableItem(_ref) {
  var label = _ref.label,
      initialChecked = _ref.initialChecked,
      _ref$onChange = _ref.onChange,
      onChange = _ref$onChange === void 0 ? function () {} : _ref$onChange;

  var _useState = useState(initialChecked),
      _useState2 = _slicedToArray(_useState, 2),
      checked = _useState2[0],
      setChecked = _useState2[1];

  function handleClick() {
    setChecked(!checked);
    onChange(!checked);
  }

  return /*#__PURE__*/React.createElement(MenuOption, {
    role: "menuitemcheckbox",
    "aria-checked": checked,
    renderIcon: checked ? Checkmark16 : null,
    label: label,
    indented: true,
    onClick: handleClick
  });
}

MenuSelectableItem.propTypes = {
  /**
   * Whether the option should be checked by default
   */
  initialChecked: PropTypes.bool,

  /**
   * Rendered label for the MenuOptionContent
   */
  label: PropTypes.node.isRequired,

  /**
   * Callback function when selection the has been changed
   */
  onChange: PropTypes.func
};
export default MenuSelectableItem;