import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React from 'react';
import cx from 'classnames';
import { settings } from 'carbon-components';
import SkeletonText from '../SkeletonText';
var prefix = settings.prefix;

function PaginationSkeleton(_ref) {
  var className = _ref.className,
      rest = _objectWithoutProperties(_ref, _excluded);

  return /*#__PURE__*/React.createElement("div", _extends({
    className: cx("".concat(prefix, "--pagination"), "".concat(prefix, "--skeleton"), className)
  }, rest), /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--pagination__left")
  }, /*#__PURE__*/React.createElement(SkeletonText, {
    width: "70px"
  }), /*#__PURE__*/React.createElement(SkeletonText, {
    width: "35px"
  }), /*#__PURE__*/React.createElement(SkeletonText, {
    width: "105px"
  })), /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--pagination__right ").concat(prefix, "--pagination--inline")
  }, /*#__PURE__*/React.createElement(SkeletonText, {
    width: "70px"
  })));
}

PaginationSkeleton.propTypes = {
  /**
   * Specify an optional className to add.
   */
  className: PropTypes.string
};
export default PaginationSkeleton;