import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _typeof from "@babel/runtime/helpers/typeof";
var _excluded = ["backwardText", "className", "disabled", "forwardText", "id", "isLastPage", "itemText", "itemRangeText", "itemsPerPageText", "onChange", "pageNumberText", "pageRangeText", "page", "pageInputDisabled", "pageSize", "pageSizeInputDisabled", "pageSizes", "pageText", "pagesUnknown", "size", "totalItems"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { CaretRight16, CaretLeft16 } from '@carbon/icons-react';
import cx from 'classnames';
import PropTypes from 'prop-types';
import React, { useState } from 'react';
import Button from '../../Button';
import Select from '../../Select';
import SelectItem from '../../SelectItem';
import { equals } from '../../../tools/array';
import { useFallbackId } from '../../../internal/useId';
import { usePrefix } from '../../../internal/usePrefix';

function mapPageSizesToObject(sizes) {
  return _typeof(sizes[0]) === 'object' && sizes[0] !== null ? sizes : sizes.map(function (size) {
    return {
      text: size,
      value: size
    };
  });
}

function renderSelectItems(total) {
  var counter = 1;
  var itemArr = [];

  while (counter <= total) {
    itemArr.push( /*#__PURE__*/React.createElement(SelectItem, {
      key: counter,
      value: counter,
      text: String(counter)
    }));
    counter++;
  }

  return itemArr;
}

function getPageSize(pageSizes, pageSize) {
  if (pageSize) {
    var hasSize = pageSizes.find(function (size) {
      return pageSize === size.value;
    });

    if (hasSize) {
      return pageSize;
    }
  }

  return pageSizes[0].value;
}

function Pagination(_ref) {
  var _cx, _cx2, _cx3;

  var _ref$backwardText = _ref.backwardText,
      backwardText = _ref$backwardText === void 0 ? 'Previous page' : _ref$backwardText,
      customClassName = _ref.className,
      _ref$disabled = _ref.disabled,
      disabled = _ref$disabled === void 0 ? false : _ref$disabled,
      _ref$forwardText = _ref.forwardText,
      forwardText = _ref$forwardText === void 0 ? 'Next page' : _ref$forwardText,
      id = _ref.id,
      _ref$isLastPage = _ref.isLastPage,
      isLastPage = _ref$isLastPage === void 0 ? false : _ref$isLastPage,
      _ref$itemText = _ref.itemText,
      itemText = _ref$itemText === void 0 ? function (min, max) {
    return "".concat(min, "\u2013").concat(max, " items");
  } : _ref$itemText,
      _ref$itemRangeText = _ref.itemRangeText,
      itemRangeText = _ref$itemRangeText === void 0 ? function (min, max, total) {
    return "".concat(min, "\u2013").concat(max, " of ").concat(total, " items");
  } : _ref$itemRangeText,
      _ref$itemsPerPageText = _ref.itemsPerPageText,
      itemsPerPageText = _ref$itemsPerPageText === void 0 ? 'Items per page:' : _ref$itemsPerPageText,
      onChange = _ref.onChange,
      _ref$pageNumberText = _ref.pageNumberText,
      _pageNumberText = _ref$pageNumberText === void 0 ? 'Page Number' : _ref$pageNumberText,
      _ref$pageRangeText = _ref.pageRangeText,
      pageRangeText = _ref$pageRangeText === void 0 ? function (_current, total) {
    return "of ".concat(total, " ").concat(total === 1 ? 'page' : 'pages');
  } : _ref$pageRangeText,
      _ref$page = _ref.page,
      controlledPage = _ref$page === void 0 ? 1 : _ref$page,
      pageInputDisabled = _ref.pageInputDisabled,
      controlledPageSize = _ref.pageSize,
      pageSizeInputDisabled = _ref.pageSizeInputDisabled,
      controlledPageSizes = _ref.pageSizes,
      _ref$pageText = _ref.pageText,
      pageText = _ref$pageText === void 0 ? function (page) {
    return "page ".concat(page);
  } : _ref$pageText,
      _ref$pagesUnknown = _ref.pagesUnknown,
      pagesUnknown = _ref$pagesUnknown === void 0 ? false : _ref$pagesUnknown,
      size = _ref.size,
      totalItems = _ref.totalItems,
      rest = _objectWithoutProperties(_ref, _excluded);

  var prefix = usePrefix();
  var inputId = useFallbackId(id);

  var _useState = useState(function () {
    return mapPageSizesToObject(controlledPageSizes);
  }),
      _useState2 = _slicedToArray(_useState, 2),
      pageSizes = _useState2[0],
      setPageSizes = _useState2[1];

  var _useState3 = useState(controlledPageSizes),
      _useState4 = _slicedToArray(_useState3, 2),
      prevPageSizes = _useState4[0],
      setPrevPageSizes = _useState4[1];

  var _useState5 = useState(controlledPage),
      _useState6 = _slicedToArray(_useState5, 2),
      page = _useState6[0],
      setPage = _useState6[1];

  var _useState7 = useState(controlledPage),
      _useState8 = _slicedToArray(_useState7, 2),
      prevControlledPage = _useState8[0],
      setPrevControlledPage = _useState8[1];

  var _useState9 = useState(function () {
    return getPageSize(pageSizes, controlledPageSize);
  }),
      _useState10 = _slicedToArray(_useState9, 2),
      pageSize = _useState10[0],
      setPageSize = _useState10[1];

  var _useState11 = useState(controlledPageSize),
      _useState12 = _slicedToArray(_useState11, 2),
      prevControlledPageSize = _useState12[0],
      setPrevControlledPageSize = _useState12[1];

  var className = cx((_cx = {}, _defineProperty(_cx, "".concat(prefix, "--pagination"), true), _defineProperty(_cx, "".concat(prefix, "--pagination--").concat(size), size), _defineProperty(_cx, customClassName, !!customClassName), _cx));
  var totalPages = Math.max(Math.ceil(totalItems / pageSize), 1);
  var backButtonDisabled = disabled || page === 1;
  var backButtonClasses = cx((_cx2 = {}, _defineProperty(_cx2, "".concat(prefix, "--pagination__button"), true), _defineProperty(_cx2, "".concat(prefix, "--pagination__button--backward"), true), _defineProperty(_cx2, "".concat(prefix, "--pagination__button--no-index"), backButtonDisabled), _cx2));
  var forwardButtonDisabled = disabled || page === totalPages;
  var forwardButtonClasses = cx((_cx3 = {}, _defineProperty(_cx3, "".concat(prefix, "--pagination__button"), true), _defineProperty(_cx3, "".concat(prefix, "--pagination__button--forward"), true), _defineProperty(_cx3, "".concat(prefix, "--pagination__button--no-index"), forwardButtonDisabled), _cx3));
  var selectItems = renderSelectItems(totalPages); // Sync state with props

  if (controlledPage !== prevControlledPage) {
    setPage(controlledPage);
    setPrevControlledPage(controlledPage);
  }

  if (controlledPageSize !== prevControlledPageSize) {
    setPageSize(getPageSize(pageSizes, controlledPageSize));
    setPrevControlledPageSize(controlledPageSize);
  }

  if (!equals(controlledPageSizes, prevPageSizes)) {
    var _pageSizes = mapPageSizesToObject(controlledPageSizes);

    var hasPageSize = _pageSizes.find(function (size) {
      return size.value === pageSize;
    }); // Reset page to 1 if the current pageSize is not included in the new page
    // sizes


    if (!hasPageSize) {
      setPage(1);
    }

    setPageSizes(_pageSizes);
    setPrevPageSizes(controlledPageSizes);
  }

  function handleSizeChange(event) {
    var pageSize = Number(event.target.value);
    var changes = {
      pageSize: pageSize,
      page: 1
    };
    setPage(changes.page);
    setPageSize(changes.pageSize);

    if (onChange) {
      onChange(changes);
    }
  }

  function handlePageInputChange(event) {
    var page = Number(event.target.value);

    if (page > 0 && page <= Math.max(Math.ceil(totalItems / pageSize), 1)) {
      setPage(page);

      if (onChange) {
        onChange({
          page: page,
          pageSize: pageSize
        });
      }
    }
  }

  function incrementPage() {
    var nextPage = page + 1;
    setPage(nextPage);

    if (onChange) {
      onChange({
        page: nextPage,
        pageSize: pageSize
      });
    }
  }

  function decrementPage() {
    var nextPage = page - 1;
    setPage(nextPage);

    if (onChange) {
      onChange({
        page: nextPage,
        pageSize: pageSize
      });
    }
  }

  return /*#__PURE__*/React.createElement("div", _extends({
    className: className
  }, rest), /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--pagination__left")
  }, /*#__PURE__*/React.createElement("label", {
    id: "".concat(prefix, "-pagination-select-").concat(inputId, "-count-label"),
    className: "".concat(prefix, "--pagination__text"),
    htmlFor: "".concat(prefix, "-pagination-select-").concat(inputId)
  }, itemsPerPageText), /*#__PURE__*/React.createElement(Select, {
    id: "".concat(prefix, "-pagination-select-").concat(inputId),
    className: "".concat(prefix, "--select__item-count"),
    labelText: "",
    hideLabel: true,
    noLabel: true,
    inline: true,
    onChange: handleSizeChange,
    disabled: pageSizeInputDisabled || disabled,
    value: pageSize
  }, pageSizes.map(function (sizeObj) {
    return /*#__PURE__*/React.createElement(SelectItem, {
      key: sizeObj.value,
      value: sizeObj.value,
      text: String(sizeObj.text)
    });
  })), /*#__PURE__*/React.createElement("span", {
    className: "".concat(prefix, "--pagination__text ").concat(prefix, "--pagination__items-count")
  }, pagesUnknown ? itemText(pageSize * (page - 1) + 1, page * pageSize) : itemRangeText(Math.min(pageSize * (page - 1) + 1, totalItems), Math.min(page * pageSize, totalItems), totalItems))), /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--pagination__right")
  }, /*#__PURE__*/React.createElement(Select, {
    id: "".concat(prefix, "-pagination-select-").concat(inputId, "-right"),
    className: "".concat(prefix, "--select__page-number"),
    labelText: "Page number, of ".concat(totalPages, " pages"),
    inline: true,
    hideLabel: true,
    onChange: handlePageInputChange,
    value: page,
    disabled: pageInputDisabled || disabled
  }, selectItems), /*#__PURE__*/React.createElement("span", {
    className: "".concat(prefix, "--pagination__text")
  }, pagesUnknown ? pageText(page) : pageRangeText(page, totalPages)), /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--pagination__control-buttons")
  }, /*#__PURE__*/React.createElement(Button, {
    kind: "ghost",
    className: backButtonClasses,
    hasIconOnly: true,
    renderIcon: CaretLeft16,
    iconDescription: backwardText,
    tooltipAlignment: "center",
    tooltipPosition: "top",
    onClick: decrementPage,
    disabled: backButtonDisabled
  }), /*#__PURE__*/React.createElement(Button, {
    kind: "ghost",
    className: forwardButtonClasses,
    hasIconOnly: true,
    renderIcon: CaretRight16,
    iconDescription: forwardText,
    tooltipAlignment: "end",
    tooltipPosition: "top",
    onClick: incrementPage,
    disabled: forwardButtonDisabled || isLastPage
  }))));
}

Pagination.propTypes = {
  /**
   * The description for the backward icon.
   */
  backwardText: PropTypes.string,

  /**
   * The CSS class names.
   */
  className: PropTypes.string,

  /**
   * `true` if the backward/forward buttons, as well as the page select elements,  should be disabled.
   */
  disabled: PropTypes.bool,

  /**
   * The description for the forward icon.
   */
  forwardText: PropTypes.string,

  /**
   * The unique ID of this component instance.
   */
  id: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),
  // TODO: remove when v9 is deprecated

  /**
   * `true` if the current page should be the last page.
   */
  isLastPage: PropTypes.bool,

  /**
   * The function returning a translatable text showing where the current page is,
   * in a manner of the range of items.
   */
  itemRangeText: PropTypes.func,

  /**
   * A variant of `itemRangeText`, used if the total number of items is unknown.
   */
  itemText: PropTypes.func,

  /**
   * The translatable text indicating the number of items per page.
   */
  itemsPerPageText: PropTypes.string,

  /**
   * The callback function called when the current page changes.
   */
  onChange: PropTypes.func,

  /**
   * The current page.
   */
  page: PropTypes.number,

  /**
   * `true` if the select box to change the page should be disabled.
   */
  pageInputDisabled: PropTypes.bool,
  pageNumberText: PropTypes.string,

  /**
   * A function returning PII showing where the current page is.
   */
  pageRangeText: PropTypes.func,

  /**
   * The number dictating how many items a page contains.
   */
  pageSize: PropTypes.number,

  /**
   * `true` if the select box to change the items per page should be disabled.
   */
  pageSizeInputDisabled: PropTypes.bool,

  /**
   * The choices for `pageSize`.
   */
  pageSizes: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.number), PropTypes.arrayOf(PropTypes.shape({
    text: PropTypes.text,
    value: PropTypes.number
  }))]).isRequired,

  /**
   * The translatable text showing the current page.
   */
  pageText: PropTypes.func,

  /**
   * `true` if the total number of items is unknown.
   */
  pagesUnknown: PropTypes.bool,

  /**
   * Specify the size of the Pagination. Currently supports either `sm`, 'md' (default) or 'lg` as an option.
   */
  size: PropTypes.oneOf(['sm', 'md', 'lg']),

  /**
   * The total number of items.
   */
  totalItems: PropTypes.number
};
export default Pagination;