import _extends from "@babel/runtime/helpers/extends";

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import { CheckmarkFilled16 } from '@carbon/icons-react';
import { withKnobs, boolean } from '@storybook/addon-knobs';
import { StructuredListWrapper, StructuredListHead, StructuredListBody, StructuredListRow, StructuredListInput, StructuredListCell, StructuredListSkeleton } from '../../StructuredList';
import { settings } from 'carbon-components';
import mdx from './StructuredList.mdx';
var prefix = settings.prefix;

var props = function props() {
  return {
    isCondensed: boolean('Condensed', false),
    isFlush: boolean('Flush alignment', false)
  };
};

export default {
  title: 'Components/StructuredList',
  decorators: [withKnobs],
  parameters: {
    component: StructuredListWrapper,
    docs: {
      page: mdx
    },
    subcomponents: {
      StructuredListHead: StructuredListHead,
      StructuredListBody: StructuredListBody,
      StructuredListRow: StructuredListRow,
      StructuredListInput: StructuredListInput,
      StructuredListCell: StructuredListCell
    }
  }
};
export var Simple = function Simple() {
  return /*#__PURE__*/React.createElement(StructuredListWrapper, null, /*#__PURE__*/React.createElement(StructuredListHead, null, /*#__PURE__*/React.createElement(StructuredListRow, {
    head: true
  }, /*#__PURE__*/React.createElement(StructuredListCell, {
    head: true
  }, "ColumnA"), /*#__PURE__*/React.createElement(StructuredListCell, {
    head: true
  }, "ColumnB"), /*#__PURE__*/React.createElement(StructuredListCell, {
    head: true
  }, "ColumnC"))), /*#__PURE__*/React.createElement(StructuredListBody, null, /*#__PURE__*/React.createElement(StructuredListRow, null, /*#__PURE__*/React.createElement(StructuredListCell, {
    noWrap: true
  }, "Row 1"), /*#__PURE__*/React.createElement(StructuredListCell, null, "Row 1"), /*#__PURE__*/React.createElement(StructuredListCell, null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc dui magna, finibus id tortor sed, aliquet bibendum augue. Aenean posuere sem vel euismod dignissim. Nulla ut cursus dolor. Pellentesque vulputate nisl a porttitor interdum.")), /*#__PURE__*/React.createElement(StructuredListRow, null, /*#__PURE__*/React.createElement(StructuredListCell, {
    noWrap: true
  }, "Row 2"), /*#__PURE__*/React.createElement(StructuredListCell, null, "Row 2"), /*#__PURE__*/React.createElement(StructuredListCell, null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc dui magna, finibus id tortor sed, aliquet bibendum augue. Aenean posuere sem vel euismod dignissim. Nulla ut cursus dolor. Pellentesque vulputate nisl a porttitor interdum."))));
};
Simple.parameters = {
  info: {
    text: "\n        Structured Lists group content that is similar or related, such as terms or definitions.\n      "
  }
};
export var Playground = function Playground() {
  return /*#__PURE__*/React.createElement(StructuredListWrapper, props(), /*#__PURE__*/React.createElement(StructuredListHead, null, /*#__PURE__*/React.createElement(StructuredListRow, {
    head: true
  }, /*#__PURE__*/React.createElement(StructuredListCell, {
    head: true
  }, "ColumnA"), /*#__PURE__*/React.createElement(StructuredListCell, {
    head: true
  }, "ColumnB"), /*#__PURE__*/React.createElement(StructuredListCell, {
    head: true
  }, "ColumnC"))), /*#__PURE__*/React.createElement(StructuredListBody, null, /*#__PURE__*/React.createElement(StructuredListRow, null, /*#__PURE__*/React.createElement(StructuredListCell, {
    noWrap: true
  }, "Row 1"), /*#__PURE__*/React.createElement(StructuredListCell, null, "Row 1"), /*#__PURE__*/React.createElement(StructuredListCell, null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc dui magna, finibus id tortor sed, aliquet bibendum augue. Aenean posuere sem vel euismod dignissim. Nulla ut cursus dolor. Pellentesque vulputate nisl a porttitor interdum.")), /*#__PURE__*/React.createElement(StructuredListRow, null, /*#__PURE__*/React.createElement(StructuredListCell, {
    noWrap: true
  }, "Row 2"), /*#__PURE__*/React.createElement(StructuredListCell, null, "Row 2"), /*#__PURE__*/React.createElement(StructuredListCell, null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc dui magna, finibus id tortor sed, aliquet bibendum augue. Aenean posuere sem vel euismod dignissim. Nulla ut cursus dolor. Pellentesque vulputate nisl a porttitor interdum."))));
};
Playground.parameters = {
  info: {
    text: "\n        Structured Lists group content that is similar or related, such as terms or definitions.\n      "
  }
};
export var Selection = function Selection() {
  var structuredListBodyRowGenerator = function structuredListBodyRowGenerator(numRows) {
    return Array.apply(null, Array(numRows)).map(function (n, i) {
      return /*#__PURE__*/React.createElement(StructuredListRow, {
        label: true,
        key: "row-".concat(i)
      }, /*#__PURE__*/React.createElement(StructuredListCell, null, "Row ", i), /*#__PURE__*/React.createElement(StructuredListCell, null, "Row ", i), /*#__PURE__*/React.createElement(StructuredListCell, null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc dui magna, finibus id tortor sed, aliquet bibendum augue. Aenean posuere sem vel euismod dignissim. Nulla ut cursus dolor. Pellentesque vulputate nisl a porttitor interdum."), /*#__PURE__*/React.createElement(StructuredListInput, {
        id: "row-".concat(i),
        value: "row-".concat(i),
        title: "row-".concat(i),
        name: "row-0",
        defaultChecked: !i || null
      }), /*#__PURE__*/React.createElement(StructuredListCell, null, /*#__PURE__*/React.createElement(CheckmarkFilled16, {
        className: "".concat(prefix, "--structured-list-svg"),
        "aria-label": "select an option"
      }, /*#__PURE__*/React.createElement("title", null, "select an option"))));
    });
  };

  return /*#__PURE__*/React.createElement(StructuredListWrapper, _extends({
    selection: true
  }, props()), /*#__PURE__*/React.createElement(StructuredListHead, null, /*#__PURE__*/React.createElement(StructuredListRow, {
    head: true
  }, /*#__PURE__*/React.createElement(StructuredListCell, {
    head: true
  }, "ColumnA"), /*#__PURE__*/React.createElement(StructuredListCell, {
    head: true
  }, "ColumnB"), /*#__PURE__*/React.createElement(StructuredListCell, {
    head: true
  }, "ColumnC"), /*#__PURE__*/React.createElement(StructuredListCell, {
    head: true
  }, ''))), /*#__PURE__*/React.createElement(StructuredListBody, null, structuredListBodyRowGenerator(4)));
};
Selection.parameters = {
  info: {
    text: "\n    Structured Lists with selection allow a row of list content to be selected.\n  "
  }
};
export var Skeleton = function Skeleton() {
  return /*#__PURE__*/React.createElement("div", {
    style: {
      width: '800px'
    }
  }, /*#__PURE__*/React.createElement(StructuredListSkeleton, null), /*#__PURE__*/React.createElement(StructuredListSkeleton, null));
};
Skeleton.storyName = 'Skeleton';
Skeleton.parameters = {
  info: {
    text: "\n        Placeholder skeleton state to use when content is loading.\n      "
  }
};