import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
var _excluded = ["id", "className", "handleTabClick", "handleTabKeyDown", "disabled", "href", "index", "label", "selected", "tabIndex", "onClick", "onKeyDown", "renderAnchor", "renderButton", "renderContent", "role"];

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React from 'react';
import classNames from 'classnames';
import * as FeatureFlags from '@carbon/feature-flags';
import { settings } from 'carbon-components';
import deprecate from '../../prop-types/deprecate';
var prefix = settings.prefix;

var Tab = /*#__PURE__*/function (_React$Component) {
  _inherits(Tab, _React$Component);

  var _super = _createSuper(Tab);

  function Tab() {
    _classCallCheck(this, Tab);

    return _super.apply(this, arguments);
  }

  _createClass(Tab, [{
    key: "render",
    value: function render() {
      var _classNames,
          _this = this,
          _buttonProps;

      var _this$props = this.props,
          id = _this$props.id,
          className = _this$props.className,
          handleTabClick = _this$props.handleTabClick,
          handleTabKeyDown = _this$props.handleTabKeyDown,
          disabled = _this$props.disabled,
          _this$props$href = _this$props.href,
          href = _this$props$href === void 0 ? '#' : _this$props$href,
          index = _this$props.index,
          label = _this$props.label,
          selected = _this$props.selected,
          _this$props$tabIndex = _this$props.tabIndex,
          tabIndex = _this$props$tabIndex === void 0 ? 0 : _this$props$tabIndex,
          _onClick = _this$props.onClick,
          _onKeyDown = _this$props.onKeyDown,
          renderAnchor = _this$props.renderAnchor,
          renderButton = _this$props.renderButton,
          renderContent = _this$props.renderContent,
          role = _this$props.role,
          other = _objectWithoutProperties(_this$props, _excluded);

      var classes = classNames(className, // TODO: remove scrollable in next major release
      // `${prefix}--tabs__nav-item`,
      "".concat(prefix, "--tabs--scrollable__nav-item"), (_classNames = {}, _defineProperty(_classNames, "".concat(prefix, "--tabs__nav-item--disabled"), disabled), _defineProperty(_classNames, "".concat(prefix, "--tabs__nav-item--selected"), selected), _defineProperty(_classNames, "".concat(prefix, "--tabs--scrollable__nav-item--disabled"), disabled), _defineProperty(_classNames, "".concat(prefix, "--tabs--scrollable__nav-item--selected"), selected), _classNames));
      var buttonProps = (_buttonProps = {}, _defineProperty(_buttonProps, 'aria-selected', selected), _defineProperty(_buttonProps, 'aria-disabled', disabled), _defineProperty(_buttonProps, 'aria-controls', id && "".concat(id, "__panel")), _defineProperty(_buttonProps, "id", id), _defineProperty(_buttonProps, "className", "".concat(prefix, "--tabs--scrollable__nav-link")), _defineProperty(_buttonProps, "href", href), _defineProperty(_buttonProps, "tabIndex", !disabled ? tabIndex : -1), _defineProperty(_buttonProps, "ref", function ref(e) {
        _this.tabAnchor = e;
      }), _buttonProps);
      var renderElement = renderButton || renderAnchor;
      return /*#__PURE__*/React.createElement("li", _extends({}, other, {
        className: classes,
        onClick: function onClick(evt) {
          if (disabled) {
            return;
          }

          if (handleTabClick) {
            handleTabClick(index, evt);
          }

          _onClick(evt);
        },
        onKeyDown: function onKeyDown(evt) {
          if (disabled) {
            return;
          }

          if (handleTabKeyDown) {
            handleTabKeyDown(index, evt);
          }

          _onKeyDown(evt);
        },
        role: "presentation"
      }), renderElement ? renderElement(buttonProps) : /*#__PURE__*/React.createElement("button", _extends({
        type: "button",
        role: "tab"
      }, buttonProps), label));
    }
  }]);

  return Tab;
}(React.Component);

_defineProperty(Tab, "propTypes", {
  /**
   * Specify an optional className to be added to your Tab
   */
  className: PropTypes.string,

  /**
   * Whether your Tab is disabled.
   */
  disabled: PropTypes.bool,

  /**
   * A handler that is invoked when a user clicks on the control.
   * Reserved for usage in Tabs
   */
  handleTabClick: PropTypes.func,

  /**
   * A handler that is invoked on the key down event for the control.
   * Reserved for usage in Tabs
   */
  handleTabKeyDown: PropTypes.func,

  /**
   * Provide a string that represents the `href` of the Tab
   */
  href: deprecate(PropTypes.string),

  /**
   * The element ID for the top-level element.
   */
  id: PropTypes.string,

  /**
   * The index of your Tab in your Tabs. Reserved for usage in Tabs
   */
  index: PropTypes.number,

  /**
   * Provide the contents of your Tab
   */
  label: FeatureFlags.enabled('enable-v11-release') ? PropTypes.node.isRequired : PropTypes.node,

  /**
   * Provide a handler that is invoked when a user clicks on the control
   */
  onClick: PropTypes.func.isRequired,

  /**
   * Provide a handler that is invoked on the key down event for the control
   */
  onKeyDown: PropTypes.func.isRequired,

  /*
   * An optional parameter to allow overriding the anchor rendering.
   * Useful for using Tab along with react-router or other client
   * side router libraries.
   **/
  renderAnchor: deprecate(PropTypes.func),
  renderButton: PropTypes.func,

  /*
   * An optional parameter to allow overriding the content rendering.
   **/
  renderContent: PropTypes.func,

  /**
   * Provide an accessibility role for your Tab
   */
  role: deprecate(PropTypes.string),

  /**
   * Whether your Tab is selected.
   * Reserved for usage in Tabs
   */
  selected: PropTypes.bool.isRequired,

  /**
   * Specify the tab index of the `<button>` node
   */
  tabIndex: PropTypes.number
});

_defineProperty(Tab, "defaultProps", {
  label: FeatureFlags.enabled('enable-v11-release') ? undefined : 'provide a label',
  selected: false,
  onClick: function onClick() {},
  onKeyDown: function onKeyDown() {}
});

export { Tab as default };