import React from 'react';
import { Tabs, Tab, TabPanel, TabPanels, TabList } from './Tabs';
import { render, screen } from '@testing-library/react';
import userEvent from '@testing-library/user-event';
describe('Tabs', function () {
  it('should update selected index based on the default provided', function () {
    render( /*#__PURE__*/React.createElement(Tabs, {
      defaultSelectedIndex: 1
    }, /*#__PURE__*/React.createElement(TabList, {
      "aria-label": "List of tabs"
    }, /*#__PURE__*/React.createElement(Tab, null, "Tab Label 1"), /*#__PURE__*/React.createElement(Tab, null, "Tab Label 2"), /*#__PURE__*/React.createElement(Tab, null, "Tab Label 3")), /*#__PURE__*/React.createElement(TabPanels, null, /*#__PURE__*/React.createElement(TabPanel, null, "Tab Panel 1"), /*#__PURE__*/React.createElement(TabPanel, null, "Tab Panel 2"), /*#__PURE__*/React.createElement(TabPanel, null, "Tab Panel 3"))));
    expect(screen.getByText('Tab Label 2')).toHaveAttribute('aria-selected', 'true');
  });
  it('should set a className from props on outermost element in TabList', function () {
    render( /*#__PURE__*/React.createElement(Tabs, null, /*#__PURE__*/React.createElement(TabList, {
      "aria-label": "List of tabs",
      className: "custom-class"
    }, /*#__PURE__*/React.createElement(Tab, {
      disabled: true
    }, "Tab Label 1"), /*#__PURE__*/React.createElement(Tab, null, "Tab Label 2"), /*#__PURE__*/React.createElement(Tab, null, "Tab Label 3")), /*#__PURE__*/React.createElement(TabPanels, null, /*#__PURE__*/React.createElement(TabPanel, null, "Tab Panel 1"), /*#__PURE__*/React.createElement(TabPanel, null, "Tab Panel 2"), /*#__PURE__*/React.createElement(TabPanel, null, "Tab Panel 3"))));
    expect(screen.getByRole('tablist')).toHaveClass('custom-class');
  });
});
describe('Tab', function () {
  it('should set a className from props on outermost element in Tab', function () {
    render( /*#__PURE__*/React.createElement(Tabs, null, /*#__PURE__*/React.createElement(TabList, {
      "aria-label": "List of tabs"
    }, /*#__PURE__*/React.createElement(Tab, {
      disabled: true
    }, "Tab Label 1"), /*#__PURE__*/React.createElement(Tab, {
      className: "custom-class"
    }, "Tab Label 2"), /*#__PURE__*/React.createElement(Tab, null, "Tab Label 3")), /*#__PURE__*/React.createElement(TabPanels, null, /*#__PURE__*/React.createElement(TabPanel, null, "Tab Panel 1"), /*#__PURE__*/React.createElement(TabPanel, null, "Tab Panel 2"), /*#__PURE__*/React.createElement(TabPanel, null, "Tab Panel 3"))));
    expect(screen.getByText('Tab Label 2')).toHaveClass('custom-class');
  });
  it('should not select a disabled tab and select next tab', function () {
    render( /*#__PURE__*/React.createElement(Tabs, null, /*#__PURE__*/React.createElement(TabList, {
      "aria-label": "List of tabs"
    }, /*#__PURE__*/React.createElement(Tab, {
      disabled: true
    }, "Tab Label 1"), /*#__PURE__*/React.createElement(Tab, null, "Tab Label 2"), /*#__PURE__*/React.createElement(Tab, null, "Tab Label 3")), /*#__PURE__*/React.createElement(TabPanels, null, /*#__PURE__*/React.createElement(TabPanel, null, "Tab Panel 1"), /*#__PURE__*/React.createElement(TabPanel, null, "Tab Panel 2"), /*#__PURE__*/React.createElement(TabPanel, null, "Tab Panel 3"))));
    expect(screen.getByText('Tab Label 1')).toHaveAttribute('aria-selected', 'false'); // By default, if a Tab is disabled, the next Tab should be selected

    expect(screen.getByText('Tab Label 2')).toHaveAttribute('aria-selected', 'true');
  });
  it('should provide a custom element to render instead of default button if provided', function () {
    render( /*#__PURE__*/React.createElement(Tabs, null, /*#__PURE__*/React.createElement(TabList, {
      "aria-label": "List of tabs"
    }, /*#__PURE__*/React.createElement(Tab, {
      as: "div"
    }, "Tab Label 1"), /*#__PURE__*/React.createElement(Tab, null, "Tab Label 2"), /*#__PURE__*/React.createElement(Tab, null, "Tab Label 3")), /*#__PURE__*/React.createElement(TabPanels, null, /*#__PURE__*/React.createElement(TabPanel, null, "Tab Panel 1"), /*#__PURE__*/React.createElement(TabPanel, null, "Tab Panel 2"), /*#__PURE__*/React.createElement(TabPanel, null, "Tab Panel 3"))));
    expect(screen.getByText('Tab Label 1').tagName).toBe('DIV');
  });
  it('should call onClick from props if provided', function () {
    var onClick = jest.fn();
    render( /*#__PURE__*/React.createElement(Tabs, null, /*#__PURE__*/React.createElement(TabList, {
      "aria-label": "List of tabs"
    }, /*#__PURE__*/React.createElement(Tab, {
      onClick: onClick
    }, "Tab Label 1"), /*#__PURE__*/React.createElement(Tab, null, "Tab Label 2"), /*#__PURE__*/React.createElement(Tab, null, "Tab Label 3")), /*#__PURE__*/React.createElement(TabPanels, null, /*#__PURE__*/React.createElement(TabPanel, null, "Tab Panel 1"), /*#__PURE__*/React.createElement(TabPanel, null, "Tab Panel 2"), /*#__PURE__*/React.createElement(TabPanel, null, "Tab Panel 3"))));
    userEvent.click(screen.getByText('Tab Label 1'));
    expect(onClick).toHaveBeenCalled();
  });
  it('should call onKeyDown from props if provided', function () {
    var onKeyDown = jest.fn();
    render( /*#__PURE__*/React.createElement(Tabs, null, /*#__PURE__*/React.createElement(TabList, {
      "aria-label": "List of tabs"
    }, /*#__PURE__*/React.createElement(Tab, {
      onKeyDown: onKeyDown
    }, "Tab Label 1"), /*#__PURE__*/React.createElement(Tab, null, "Tab Label 2"), /*#__PURE__*/React.createElement(Tab, null, "Tab Label 3")), /*#__PURE__*/React.createElement(TabPanels, null, /*#__PURE__*/React.createElement(TabPanel, null, "Tab Panel 1"), /*#__PURE__*/React.createElement(TabPanel, null, "Tab Panel 2"), /*#__PURE__*/React.createElement(TabPanel, null, "Tab Panel 3"))));
    userEvent.type(screen.getByText('Tab Label 1'), 'enter');
    expect(onKeyDown).toHaveBeenCalled();
  });
});
describe('TabPanel', function () {
  it('should have a className if provided by props', function () {
    render( /*#__PURE__*/React.createElement(Tabs, null, /*#__PURE__*/React.createElement(TabList, {
      "aria-label": "List of tabs"
    }, /*#__PURE__*/React.createElement(Tab, null, "Tab Label 1"), /*#__PURE__*/React.createElement(Tab, null, "Tab Label 2"), /*#__PURE__*/React.createElement(Tab, null, "Tab Label 3")), /*#__PURE__*/React.createElement(TabPanels, null, /*#__PURE__*/React.createElement(TabPanel, {
      className: "custom-class"
    }, "Tab Panel 1"), /*#__PURE__*/React.createElement(TabPanel, null, "Tab Panel 2"), /*#__PURE__*/React.createElement(TabPanel, null, "Tab Panel 3"))));
    expect(screen.getByText('Tab Panel 1')).toHaveClass('custom-class');
  });
});