"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.Table = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _carbonComponents = require("carbon-components");

var _deprecate = _interopRequireDefault(require("../../prop-types/deprecate.js"));

var _excluded = ["className", "children", "useZebraStyles", "size", "isSortable", "useStaticWidth", "shouldShowBorder", "stickyHeader", "overflowMenuOnHover"];
var prefix = _carbonComponents.settings.prefix;

var Table = function Table(_ref) {
  var _cx;

  var className = _ref.className,
      children = _ref.children,
      useZebraStyles = _ref.useZebraStyles,
      size = _ref.size,
      isSortable = _ref.isSortable,
      useStaticWidth = _ref.useStaticWidth,
      shouldShowBorder = _ref.shouldShowBorder,
      stickyHeader = _ref.stickyHeader,
      overflowMenuOnHover = _ref.overflowMenuOnHover,
      other = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var componentClass = (0, _classnames.default)("".concat(prefix, "--data-table"), className, (_cx = {}, (0, _defineProperty2.default)(_cx, "".concat(prefix, "--data-table--").concat(size), size), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--data-table--sort"), isSortable), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--data-table--zebra"), useZebraStyles), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--data-table--static"), useStaticWidth), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--data-table--no-border"), !shouldShowBorder), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--data-table--sticky-header"), stickyHeader), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--data-table--visible-overflow-menu"), !overflowMenuOnHover), _cx));

  var table = /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--data-table-content")
  }, /*#__PURE__*/_react.default.createElement("table", (0, _extends2.default)({}, other, {
    className: componentClass
  }), children));

  return stickyHeader ? /*#__PURE__*/_react.default.createElement("section", {
    className: "".concat(prefix, "--data-table_inner-container")
  }, table) : table;
};

exports.Table = Table;
Table.propTypes = {
  /**
   * Pass in the children that will be rendered within the Table
   */
  children: _propTypes.default.node,
  className: _propTypes.default.string,

  /**
   * `false` If true, will apply sorting styles
   */
  isSortable: _propTypes.default.bool,

  /**
   * Specify whether the overflow menu (if it exists) should be shown always, or only on hover
   */
  overflowMenuOnHover: _propTypes.default.bool,

  /**
   * `false` If true, will remove the table border
   */
  shouldShowBorder: (0, _deprecate.default)(_propTypes.default.bool, 'The `shouldShowBorder` prop has been deprecated and can be safely removed.' + 'This prop will be removed in the next major release of ' + '`carbon-components-react`'),

  /**
   *  Change the row height of table. Currently supports `xs`, `sm`, `md`, `lg`, and `xl`.
   *  The previous terms (`compact`, `short`, `normal`, and `tall`) will be removed in the next major release.
   */
  size: _propTypes.default.oneOf(['compact', 'short', 'normal', 'tall', 'xs', 'sm', 'md', 'lg', 'xl']),

  /**
   * `false` If true, will keep the header sticky (only data rows will scroll)
   */
  stickyHeader: _propTypes.default.bool,

  /**
   * `false` If true, will use a width of 'auto' instead of 100%
   */
  useStaticWidth: _propTypes.default.bool,

  /**
   * `true` to add useZebraStyles striping.
   */
  useZebraStyles: _propTypes.default.bool
};
Table.defaultProps = {
  isSortable: false,
  overflowMenuOnHover: true
};
var _default = Table;
exports.default = _default;