"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BatchExpansion = exports.ExtraLargeExpansion = exports.MediumExpansion = exports.SmallExpansion = exports.ExtraSmallExpansion = exports.Usage = exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

require("./DataTable-expansion-story.scss");

var _addonActions = require("@storybook/addon-actions");

var _react = _interopRequireDefault(require("react"));

var _Button = _interopRequireDefault(require("../../../Button"));

var _DataTable = _interopRequireWildcard(require("../../../DataTable"));

var _shared = require("../shared");

var _DataTable2 = _interopRequireDefault(require("../../DataTable.mdx"));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var _default = {
  title: 'Components/DataTable/Expansion',
  component: _DataTable.default,
  subcomponents: {
    TableExpandHeader: _DataTable.TableExpandHeader,
    TableExpandRow: _DataTable.TableExpandRow,
    TableExpandedRow: _DataTable.TableExpandedRow,
    Table: _DataTable.Table,
    TableBody: _DataTable.TableBody,
    TableCell: _DataTable.TableCell,
    TableContainer: _DataTable.TableContainer,
    TableHead: _DataTable.TableHead,
    TableHeader: _DataTable.TableHeader,
    TableRow: _DataTable.TableRow
  },
  parameters: {
    docs: {
      page: _DataTable2.default
    }
  }
};
exports.default = _default;

var Usage = function Usage() {
  return /*#__PURE__*/_react.default.createElement(_DataTable.default, {
    rows: _shared.rows,
    headers: _shared.headers
  }, function (_ref) {
    var rows = _ref.rows,
        headers = _ref.headers,
        getHeaderProps = _ref.getHeaderProps,
        getRowProps = _ref.getRowProps,
        getTableProps = _ref.getTableProps,
        getTableContainerProps = _ref.getTableContainerProps;
    return /*#__PURE__*/_react.default.createElement(_DataTable.TableContainer, (0, _extends2.default)({
      title: "DataTable",
      description: "With expansion"
    }, getTableContainerProps()), /*#__PURE__*/_react.default.createElement(_DataTable.Table, getTableProps(), /*#__PURE__*/_react.default.createElement(_DataTable.TableHead, null, /*#__PURE__*/_react.default.createElement(_DataTable.TableRow, null, /*#__PURE__*/_react.default.createElement(_DataTable.TableExpandHeader, null), headers.map(function (header, i) {
      return /*#__PURE__*/_react.default.createElement(_DataTable.TableHeader, (0, _extends2.default)({
        key: i
      }, getHeaderProps({
        header: header
      })), header.header);
    }))), /*#__PURE__*/_react.default.createElement(_DataTable.TableBody, null, rows.map(function (row) {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
        key: row.id
      }, /*#__PURE__*/_react.default.createElement(_DataTable.TableExpandRow, getRowProps({
        row: row
      }), row.cells.map(function (cell) {
        return /*#__PURE__*/_react.default.createElement(_DataTable.TableCell, {
          key: cell.id
        }, cell.value);
      })), /*#__PURE__*/_react.default.createElement(_DataTable.TableExpandedRow, {
        colSpan: headers.length + 1,
        className: "demo-expanded-td"
      }, /*#__PURE__*/_react.default.createElement("h6", null, "Expandable row content"), /*#__PURE__*/_react.default.createElement("div", null, "Description here")));
    }))));
  });
};

exports.Usage = Usage;

var ExtraSmallExpansion = function ExtraSmallExpansion() {
  return /*#__PURE__*/_react.default.createElement(_DataTable.default, {
    rows: _shared.rows,
    headers: _shared.headers
  }, function (_ref2) {
    var rows = _ref2.rows,
        headers = _ref2.headers,
        getHeaderProps = _ref2.getHeaderProps,
        getRowProps = _ref2.getRowProps,
        getTableProps = _ref2.getTableProps,
        onInputChange = _ref2.onInputChange,
        getToolbarProps = _ref2.getToolbarProps,
        getTableContainerProps = _ref2.getTableContainerProps;
    return /*#__PURE__*/_react.default.createElement(_DataTable.TableContainer, (0, _extends2.default)({
      title: "DataTable",
      description: "With expansion"
    }, getTableContainerProps()), /*#__PURE__*/_react.default.createElement(_DataTable.TableToolbar, (0, _extends2.default)({}, getToolbarProps(), {
      size: "xs"
    }), /*#__PURE__*/_react.default.createElement(_DataTable.TableToolbarContent, null, /*#__PURE__*/_react.default.createElement(_DataTable.TableToolbarSearch, {
      persistent: "true",
      onChange: onInputChange
    }), /*#__PURE__*/_react.default.createElement(_DataTable.TableToolbarMenu, null, /*#__PURE__*/_react.default.createElement(_DataTable.TableToolbarAction, {
      onClick: function onClick() {
        return alert('Alert 1');
      }
    }, "Action 1"), /*#__PURE__*/_react.default.createElement(_DataTable.TableToolbarAction, {
      onClick: function onClick() {
        return alert('Alert 2');
      }
    }, "Action 2"), /*#__PURE__*/_react.default.createElement(_DataTable.TableToolbarAction, {
      onClick: function onClick() {
        return alert('Alert 3');
      }
    }, "Action 3")), /*#__PURE__*/_react.default.createElement(_Button.default, {
      onClick: (0, _addonActions.action)('Add new row'),
      size: "small",
      kind: "primary"
    }, "Add new"))), /*#__PURE__*/_react.default.createElement(_DataTable.Table, (0, _extends2.default)({}, getTableProps(), {
      size: "compact"
    }), /*#__PURE__*/_react.default.createElement(_DataTable.TableHead, null, /*#__PURE__*/_react.default.createElement(_DataTable.TableRow, null, /*#__PURE__*/_react.default.createElement(_DataTable.TableExpandHeader, null), headers.map(function (header, i) {
      return /*#__PURE__*/_react.default.createElement(_DataTable.TableHeader, (0, _extends2.default)({
        key: i
      }, getHeaderProps({
        header: header
      })), header.header);
    }))), /*#__PURE__*/_react.default.createElement(_DataTable.TableBody, null, rows.map(function (row) {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
        key: row.id
      }, /*#__PURE__*/_react.default.createElement(_DataTable.TableExpandRow, getRowProps({
        row: row
      }), row.cells.map(function (cell) {
        return /*#__PURE__*/_react.default.createElement(_DataTable.TableCell, {
          key: cell.id
        }, cell.value);
      })), /*#__PURE__*/_react.default.createElement(_DataTable.TableExpandedRow, {
        colSpan: headers.length + 1,
        className: "demo-expanded-td"
      }, /*#__PURE__*/_react.default.createElement("h6", null, "Expandable row content"), /*#__PURE__*/_react.default.createElement("div", null, "Description here")));
    }))));
  });
};

exports.ExtraSmallExpansion = ExtraSmallExpansion;

var SmallExpansion = function SmallExpansion() {
  return /*#__PURE__*/_react.default.createElement(_DataTable.default, {
    rows: _shared.rows,
    headers: _shared.headers
  }, function (_ref3) {
    var rows = _ref3.rows,
        headers = _ref3.headers,
        getHeaderProps = _ref3.getHeaderProps,
        getRowProps = _ref3.getRowProps,
        getTableProps = _ref3.getTableProps,
        getTableContainerProps = _ref3.getTableContainerProps;
    return /*#__PURE__*/_react.default.createElement(_DataTable.TableContainer, (0, _extends2.default)({
      title: "DataTable",
      description: "With expansion"
    }, getTableContainerProps()), /*#__PURE__*/_react.default.createElement(_DataTable.Table, (0, _extends2.default)({}, getTableProps(), {
      size: "sm"
    }), /*#__PURE__*/_react.default.createElement(_DataTable.TableHead, null, /*#__PURE__*/_react.default.createElement(_DataTable.TableRow, null, /*#__PURE__*/_react.default.createElement(_DataTable.TableExpandHeader, null), headers.map(function (header, i) {
      return /*#__PURE__*/_react.default.createElement(_DataTable.TableHeader, (0, _extends2.default)({
        key: i
      }, getHeaderProps({
        header: header
      })), header.header);
    }))), /*#__PURE__*/_react.default.createElement(_DataTable.TableBody, null, rows.map(function (row) {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
        key: row.id
      }, /*#__PURE__*/_react.default.createElement(_DataTable.TableExpandRow, getRowProps({
        row: row
      }), row.cells.map(function (cell) {
        return /*#__PURE__*/_react.default.createElement(_DataTable.TableCell, {
          key: cell.id
        }, cell.value);
      })), /*#__PURE__*/_react.default.createElement(_DataTable.TableExpandedRow, {
        colSpan: headers.length + 1,
        className: "demo-expanded-td"
      }, /*#__PURE__*/_react.default.createElement("h6", null, "Expandable row content"), /*#__PURE__*/_react.default.createElement("div", null, "Description here")));
    }))));
  });
};

exports.SmallExpansion = SmallExpansion;

var MediumExpansion = function MediumExpansion() {
  return /*#__PURE__*/_react.default.createElement(_DataTable.default, {
    rows: _shared.rows,
    headers: _shared.headers
  }, function (_ref4) {
    var rows = _ref4.rows,
        headers = _ref4.headers,
        getHeaderProps = _ref4.getHeaderProps,
        getRowProps = _ref4.getRowProps,
        getTableProps = _ref4.getTableProps,
        getTableContainerProps = _ref4.getTableContainerProps;
    return /*#__PURE__*/_react.default.createElement(_DataTable.TableContainer, (0, _extends2.default)({
      title: "DataTable",
      description: "With expansion"
    }, getTableContainerProps()), /*#__PURE__*/_react.default.createElement(_DataTable.Table, (0, _extends2.default)({}, getTableProps(), {
      size: "md"
    }), /*#__PURE__*/_react.default.createElement(_DataTable.TableHead, null, /*#__PURE__*/_react.default.createElement(_DataTable.TableRow, null, /*#__PURE__*/_react.default.createElement(_DataTable.TableExpandHeader, null), headers.map(function (header, i) {
      return /*#__PURE__*/_react.default.createElement(_DataTable.TableHeader, (0, _extends2.default)({
        key: i
      }, getHeaderProps({
        header: header
      })), header.header);
    }))), /*#__PURE__*/_react.default.createElement(_DataTable.TableBody, null, rows.map(function (row) {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
        key: row.id
      }, /*#__PURE__*/_react.default.createElement(_DataTable.TableExpandRow, getRowProps({
        row: row
      }), row.cells.map(function (cell) {
        return /*#__PURE__*/_react.default.createElement(_DataTable.TableCell, {
          key: cell.id
        }, cell.value);
      })), /*#__PURE__*/_react.default.createElement(_DataTable.TableExpandedRow, {
        colSpan: headers.length + 1,
        className: "demo-expanded-td"
      }, /*#__PURE__*/_react.default.createElement("h6", null, "Expandable row content"), /*#__PURE__*/_react.default.createElement("div", null, "Description here")));
    }))));
  });
};

exports.MediumExpansion = MediumExpansion;

var ExtraLargeExpansion = function ExtraLargeExpansion() {
  return /*#__PURE__*/_react.default.createElement(_DataTable.default, {
    rows: _shared.rows,
    headers: _shared.headers
  }, function (_ref5) {
    var rows = _ref5.rows,
        headers = _ref5.headers,
        getHeaderProps = _ref5.getHeaderProps,
        getRowProps = _ref5.getRowProps,
        getTableProps = _ref5.getTableProps,
        getTableContainerProps = _ref5.getTableContainerProps;
    return /*#__PURE__*/_react.default.createElement(_DataTable.TableContainer, (0, _extends2.default)({
      title: "DataTable",
      description: "With expansion"
    }, getTableContainerProps()), /*#__PURE__*/_react.default.createElement(_DataTable.Table, (0, _extends2.default)({}, getTableProps(), {
      size: "xl"
    }), /*#__PURE__*/_react.default.createElement(_DataTable.TableHead, null, /*#__PURE__*/_react.default.createElement(_DataTable.TableRow, null, /*#__PURE__*/_react.default.createElement(_DataTable.TableExpandHeader, null), headers.map(function (header, i) {
      return /*#__PURE__*/_react.default.createElement(_DataTable.TableHeader, (0, _extends2.default)({
        key: i
      }, getHeaderProps({
        header: header
      })), header.header);
    }))), /*#__PURE__*/_react.default.createElement(_DataTable.TableBody, null, rows.map(function (row) {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
        key: row.id
      }, /*#__PURE__*/_react.default.createElement(_DataTable.TableExpandRow, getRowProps({
        row: row
      }), row.cells.map(function (cell) {
        return /*#__PURE__*/_react.default.createElement(_DataTable.TableCell, {
          key: cell.id
        }, cell.value);
      })), /*#__PURE__*/_react.default.createElement(_DataTable.TableExpandedRow, {
        colSpan: headers.length + 1,
        className: "demo-expanded-td"
      }, /*#__PURE__*/_react.default.createElement("h6", null, "Expandable row content"), /*#__PURE__*/_react.default.createElement("div", null, "Description here")));
    }))));
  });
};

exports.ExtraLargeExpansion = ExtraLargeExpansion;

var BatchExpansion = function BatchExpansion() {
  return /*#__PURE__*/_react.default.createElement(_DataTable.default, {
    rows: _shared.rows,
    headers: _shared.headers,
    render: function render(_ref6) {
      var rows = _ref6.rows,
          headers = _ref6.headers,
          getHeaderProps = _ref6.getHeaderProps,
          getExpandHeaderProps = _ref6.getExpandHeaderProps,
          getRowProps = _ref6.getRowProps,
          getTableProps = _ref6.getTableProps,
          getTableContainerProps = _ref6.getTableContainerProps;
      return /*#__PURE__*/_react.default.createElement(_DataTable.TableContainer, (0, _extends2.default)({
        title: "DataTable",
        description: "With batch expansion"
      }, getTableContainerProps()), /*#__PURE__*/_react.default.createElement(_DataTable.Table, getTableProps(), /*#__PURE__*/_react.default.createElement(_DataTable.TableHead, null, /*#__PURE__*/_react.default.createElement(_DataTable.TableRow, null, /*#__PURE__*/_react.default.createElement(_DataTable.TableExpandHeader, (0, _extends2.default)({
        enableExpando: true
      }, getExpandHeaderProps())), headers.map(function (header, i) {
        return /*#__PURE__*/_react.default.createElement(_DataTable.TableHeader, (0, _extends2.default)({
          key: i
        }, getHeaderProps({
          header: header
        })), header.header);
      }))), /*#__PURE__*/_react.default.createElement(_DataTable.TableBody, null, rows.map(function (row) {
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
          key: row.id
        }, /*#__PURE__*/_react.default.createElement(_DataTable.TableExpandRow, getRowProps({
          row: row
        }), row.cells.map(function (cell) {
          return /*#__PURE__*/_react.default.createElement(_DataTable.TableCell, {
            key: cell.id
          }, cell.value);
        })), /*#__PURE__*/_react.default.createElement(_DataTable.TableExpandedRow, {
          colSpan: headers.length + 1,
          className: "demo-expanded-td"
        }, /*#__PURE__*/_react.default.createElement("h6", null, "Expandable row content"), /*#__PURE__*/_react.default.createElement("div", null, "Description here")));
      }))));
    }
  });
};

exports.BatchExpansion = BatchExpansion;