"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Skeleton = exports.DragAndDropUploadContainerExampleApplication = exports._FileUploaderDropContainer = exports._FileUploaderItem = exports._FileUploader = exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _carbonComponents = require("carbon-components");

var _ = _interopRequireWildcard(require("../"));

var _FileUploader2 = _interopRequireDefault(require("./FileUploader.mdx"));

require("./FileUploader-story.scss");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

/* eslint-disable no-console */
var prefix = _carbonComponents.settings.prefix;
var filenameStatuses = ['edit', 'complete', 'uploading'];
var _default = {
  title: 'Components/FileUploader',
  parameters: {
    component: _.default,
    docs: {
      page: _FileUploader2.default
    },
    subcomponents: {
      FileUploaderButton: _.FileUploaderButton,
      FileUploaderSkeleton: _.FileUploaderSkeleton,
      FileUploaderItem: _.FileUploaderItem,
      FileUploaderDropContainer: _.FileUploaderDropContainer
    }
  }
};
exports.default = _default;

var _FileUploader = function _FileUploader(args) {
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--file__container")
  }, /*#__PURE__*/_react.default.createElement(_.default, args));
};

exports._FileUploader = _FileUploader;
_FileUploader.args = {
  labelTitle: 'Upload files',
  labelDescription: 'Max file size is 500mb. Only .jpg files are supported.',
  buttonLabel: 'Add file',
  buttonKind: 'primary',
  size: 'default',
  filenameStatus: 'edit',
  accept: ['.jpg', '.png'],
  name: '',
  multiple: true,
  iconDescription: 'Clear file'
};
_FileUploader.argTypes = {
  onChange: {
    action: 'onChange'
  },
  onClick: {
    action: 'onClick'
  },
  onDelete: {
    action: 'onDelete'
  },
  buttonKind: {
    control: {
      type: 'select'
    },
    options: ['primary', 'secondary', 'danger', 'ghost', 'danger--primary', 'tertiary']
  },
  filenameStatus: {
    control: {
      type: 'select'
    },
    options: filenameStatuses
  },
  size: {
    control: {
      type: 'select'
    },
    options: ['field', 'small', 'default', 'sm', 'md', 'lg']
  }
};

var _FileUploaderItem = function _FileUploaderItem(args) {
  return /*#__PURE__*/_react.default.createElement(_.FileUploaderItem, args);
};

exports._FileUploaderItem = _FileUploaderItem;
_FileUploaderItem.args = {
  name: 'README.md',
  status: 'edit',
  iconDescription: 'Clear file',
  invalid: false,
  errorSubject: 'File size exceeds limit',
  errorBody: '500kb max file size. Select a new file and try again.'
};
_FileUploaderItem.argTypes = {
  onDelete: {
    action: 'onDelete'
  },
  status: {
    control: {
      type: 'select'
    },
    options: filenameStatuses
  }
};

var _FileUploaderDropContainer = function _FileUploaderDropContainer(args) {
  return /*#__PURE__*/_react.default.createElement(_.FileUploaderDropContainer, args);
};

exports._FileUploaderDropContainer = _FileUploaderDropContainer;
_FileUploaderDropContainer.args = {
  labelText: 'Drag and drop files here or click to upload',
  name: '',
  multiple: true,
  accept: ['image/jpeg', 'image/png'],
  disabled: false,
  role: '',
  tabIndex: 0
};
_FileUploaderDropContainer.argTypes = {
  onChange: {
    action: 'onChange'
  }
};

var DragAndDropUploadContainerExampleApplication = function DragAndDropUploadContainerExampleApplication(args) {
  return require('./stories/drop-container').default(args);
};

exports.DragAndDropUploadContainerExampleApplication = DragAndDropUploadContainerExampleApplication;
DragAndDropUploadContainerExampleApplication.args = {
  labelText: 'Drag and drop files here or click to upload',
  name: '',
  multiple: true,
  accept: ['image/jpeg', 'image/png'],
  disabled: false,
  role: '',
  tabIndex: 0
};
DragAndDropUploadContainerExampleApplication.argTypes = {
  onChange: {
    action: 'onChange'
  }
};

var Skeleton = function Skeleton() {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: '500px'
    }
  }, /*#__PURE__*/_react.default.createElement(_.FileUploaderSkeleton, null));
};

exports.Skeleton = Skeleton;