"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _FeatureFlags = require("../FeatureFlags");

var _usePrefix = require("../../internal/usePrefix");

var _excluded = ["as", "children", "className", "sm", "md", "lg", "xlg", "max"];

function Column(_ref) {
  var _ref$as = _ref.as,
      BaseComponent = _ref$as === void 0 ? 'div' : _ref$as,
      children = _ref.children,
      containerClassName = _ref.className,
      sm = _ref.sm,
      md = _ref.md,
      lg = _ref.lg,
      xlg = _ref.xlg,
      max = _ref.max,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var prefix = (0, _usePrefix.usePrefix)();
  var hasCSSGrid = (0, _FeatureFlags.useFeatureFlag)('enable-css-grid');
  var columnClassName = hasCSSGrid ? getClassNameForBreakpoints([sm, md, lg, xlg, max], prefix) : getClassNameForFlexGridBreakpoints([sm, md, lg, xlg, max], prefix);
  var className = (0, _classnames.default)(containerClassName, columnClassName, (0, _defineProperty2.default)({}, "".concat(prefix, "--col"), columnClassName.length === 0));
  return /*#__PURE__*/_react.default.createElement(BaseComponent, (0, _extends2.default)({
    className: className
  }, rest), children);
}

var spanPropType = _propTypes.default.oneOfType([_propTypes.default.bool, _propTypes.default.number, _propTypes.default.shape({
  span: _propTypes.default.number,
  offset: _propTypes.default.number
})]);

Column.propTypes = {
  /**
   * Provide a custom element to render instead of the default <div>
   */
  as: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.elementType]),

  /**
   * Pass in content that will be rendered within the `Column`
   */
  children: _propTypes.default.node,

  /**
   * Specify a custom className to be applied to the `Column`
   */
  className: _propTypes.default.string,

  /**
   * Specify column span for the `lg` breakpoint (Default breakpoint up to 1312px)
   * This breakpoint supports 16 columns by default.
   *
   * @see https://www.carbondesignsystem.com/guidelines/layout#breakpoints
   */
  lg: spanPropType,

  /**
   * Specify column span for the `max` breakpoint. This breakpoint supports 16
   * columns by default.
   *
   * @see https://www.carbondesignsystem.com/guidelines/layout#breakpoints
   */
  max: spanPropType,

  /**
   * Specify column span for the `md` breakpoint (Default breakpoint up to 1056px)
   * This breakpoint supports 8 columns by default.
   *
   * @see https://www.carbondesignsystem.com/guidelines/layout#breakpoints
   */
  md: spanPropType,

  /**
   * Specify column span for the `sm` breakpoint (Default breakpoint up to 672px)
   * This breakpoint supports 4 columns by default.
   *
   * @see https://www.carbondesignsystem.com/guidelines/layout#breakpoints
   */
  sm: spanPropType,

  /**
   * Specify column span for the `xlg` breakpoint (Default breakpoint up to
   * 1584px) This breakpoint supports 16 columns by default.
   *
   * @see https://www.carbondesignsystem.com/guidelines/layout#breakpoints
   */
  xlg: spanPropType
};
var breakpointNames = ['sm', 'md', 'lg', 'xlg', 'max'];
/**
 * @typedef {object} Breakpoint
 * @property {boolean|number} [span]
 * @property {number} [offset]
 */

/**
 * Build the appropriate className for the given set of breakpoints.
 * @param {Array<boolean|number|Breakpoint>} breakpoints
 * @returns {string}
 */

function getClassNameForBreakpoints(breakpoints, prefix) {
  var classNames = [];

  for (var i = 0; i < breakpoints.length; i++) {
    var breakpoint = breakpoints[i];

    if (breakpoint === undefined || breakpoint === null) {
      continue;
    }

    var name = breakpointNames[i]; // If our breakpoint is a boolean, the user has specified that the column
    // should be "auto" at this size

    if (breakpoint === true) {
      classNames.push("".concat(prefix, "--").concat(name, ":col-span-auto"));
      continue;
    } // If our breakpoint is a number, the user has specified the number of
    // columns they'd like this column to span


    if (typeof breakpoint === 'number') {
      classNames.push("".concat(prefix, "--").concat(name, ":col-span-").concat(breakpoint));
      continue;
    }

    var span = breakpoint.span,
        offset = breakpoint.offset;

    if (typeof offset === 'number' && offset > 0) {
      classNames.push("".concat(prefix, "--").concat(name, ":col-start-").concat(offset + 1));
    }

    if (typeof span === 'number') {
      classNames.push("".concat(prefix, "--").concat(name, ":col-span-").concat(span));
    }

    if (span === true) {
      classNames.push("".concat(prefix, "--").concat(name, ":col-span-auto"));
    }
  }

  return classNames.join(' ');
}
/**
 * Build the appropriate className for the given set of breakpoints.
 * @param {Array<boolean|number|Breakpoint>} breakpoints
 * @returns {string}
 */


function getClassNameForFlexGridBreakpoints(breakpoints, prefix) {
  var classNames = [];

  for (var i = 0; i < breakpoints.length; i++) {
    var breakpoint = breakpoints[i];

    if (breakpoint === undefined || breakpoint === null) {
      continue;
    }

    var name = breakpointNames[i]; // If our breakpoint is a boolean, the user has specified that the column
    // should be "auto" at this size

    if (breakpoint === true) {
      classNames.push("".concat(prefix, "--col-").concat(name));
      continue;
    } // If our breakpoint is a number, the user has specified the number of
    // columns they'd like this column to span


    if (typeof breakpoint === 'number') {
      classNames.push("".concat(prefix, "--col-").concat(name, "-").concat(breakpoint));
      continue;
    }

    var span = breakpoint.span,
        offset = breakpoint.offset;

    if (typeof span === 'number') {
      classNames.push("".concat(prefix, "--col-").concat(name, "-").concat(span));
    }

    if (span === true) {
      classNames.push("".concat(prefix, "--col-").concat(name));
    }

    if (typeof offset === 'number') {
      classNames.push("".concat(prefix, "--offset-").concat(name, "-").concat(offset));
    }
  }

  return classNames.join(' ');
}

var _default = Column;
exports.default = _default;