"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _carbonComponents = require("carbon-components");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _ListBoxMenuItem = _interopRequireDefault(require("./ListBoxMenuItem"));

var _excluded = ["children", "id"];
var prefix = _carbonComponents.settings.prefix;
/**
 * `ListBoxMenu` is a simple container node that isolates the `list-box__menu`
 * class into a single component. It is also being used to validate given
 * `children` components.
 */

var ListBoxMenu = /*#__PURE__*/_react.default.forwardRef(function ListBoxMenu(_ref, ref) {
  var children = _ref.children,
      id = _ref.id,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    ref: ref,
    id: id,
    className: "".concat(prefix, "--list-box__menu"),
    role: "listbox"
  }, rest), children);
});

ListBoxMenu.displayName = 'ListBoxMenu';
ListBoxMenu.propTypes = {
  /**
   * Provide the contents of your ListBoxMenu
   */
  children: _propTypes.default.oneOfType([_propTypes.default.node, _propTypes.default.arrayOf(_ListBoxMenuItem.default),
  /**
   * allow single item using the workaround for functional components
   * https://github.com/facebook/react/issues/2979#issuecomment-222379916
   */
  _propTypes.default.shape({
    type: _propTypes.default.oneOf([_ListBoxMenuItem.default])
  }), _propTypes.default.bool // used in Dropdown for closed state
  ]),

  /**
   * Specify a custom `id`
   */
  id: _propTypes.default.string.isRequired
};
var _default = ListBoxMenu;
exports.default = _default;