"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildMenu = exports.StoryFrame = void 0;

var _react = _interopRequireDefault(require("react"));

var _addonActions = require("@storybook/addon-actions");

var _Notification = require("../Notification");

var _Menu = require("../Menu");

var InfoBanner = function InfoBanner() {
  return /*#__PURE__*/_react.default.createElement(_Notification.InlineNotification, {
    kind: "info",
    title: "Experimental component",
    subtitle: "This component is considered experimental. Its API may change until the stable version is released.",
    lowContrast: true,
    hideCloseButton: true
  });
}; // eslint-disable-next-line react/prop-types


var StoryFrame = function StoryFrame(_ref) {
  var children = _ref.children;
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      height: 'calc(100vh - 6.25rem)'
    }
  }, /*#__PURE__*/_react.default.createElement(InfoBanner, null), children);
};

exports.StoryFrame = StoryFrame;

function renderItem(item, i) {
  switch (item.type) {
    case 'item':
      return /*#__PURE__*/_react.default.createElement(_Menu.MenuItem, {
        key: i,
        label: item.label,
        shortcut: item.shortcut,
        disabled: item.disabled,
        kind: item.kind,
        onClick: !item.children ? (0, _addonActions.action)('onClick') : null
      }, item.children && item.children.map(renderItem));

    case 'divider':
      return /*#__PURE__*/_react.default.createElement(_Menu.MenuDivider, {
        key: i
      });

    case 'selectable':
      return /*#__PURE__*/_react.default.createElement(_Menu.MenuSelectableItem, {
        key: i,
        label: item.label,
        initialChecked: item.initialChecked,
        onChange: (0, _addonActions.action)('onChange')
      });

    case 'radiogroup':
      return /*#__PURE__*/_react.default.createElement(_Menu.MenuRadioGroup, {
        key: i,
        label: item.label,
        items: item.items,
        initialSelectedItem: item.initialSelectedItem,
        onChange: (0, _addonActions.action)('onChange')
      });

    case 'group':
      return /*#__PURE__*/_react.default.createElement(_Menu.MenuGroup, {
        key: i,
        label: item.label
      }, item.children && item.children.map(renderItem));
  }
}

var buildMenu = function buildMenu(items) {
  return items.map(renderItem);
};

exports.buildMenu = buildMenu;