"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TextDirection = TextDirection;

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _TextDirectionContext = require("./TextDirectionContext");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
function TextDirection(_ref) {
  var children = _ref.children,
      _ref$dir = _ref.dir,
      dir = _ref$dir === void 0 ? 'auto' : _ref$dir,
      getTextDirection = _ref.getTextDirection;
  var savedCallback = (0, _react.useRef)(getTextDirection);
  var value = (0, _react.useMemo)(function () {
    return {
      direction: dir,
      getTextDirection: savedCallback
    };
  }, [dir]);
  (0, _react.useEffect)(function () {
    savedCallback.current = getTextDirection;
  });
  return /*#__PURE__*/_react.default.createElement(_TextDirectionContext.TextDirectionContext.Provider, {
    value: value
  }, children);
}

TextDirection.propTypes = {
  /**
   * Provide children to be rendered inside of this component
   */
  children: _propTypes.default.node,

  /**
   * Specify the text direction for rendered children
   */
  dir: _propTypes.default.oneOf(['ltr', 'rtl', 'auto']),

  /**
   * Optionally provide a custom function to get the text direction for a piece
   * of text. Whatever is returned will become the value of the `dir` attribute
   * on a node of text. Should return one of: 'ltr', 'rtl', or 'auto'
   */
  getTextDirection: _propTypes.default.func
};