"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Skeleton = exports.withLayer = exports.TogglePasswordVisibility = exports.Fluid = exports.Default = exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _FluidForm = _interopRequireDefault(require("../../FluidForm"));

var _TextInput = _interopRequireWildcard(require("../../TextInput"));

var _Layer = require("../../Layer");

var _TextInput2 = _interopRequireDefault(require("./TextInput.mdx"));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var _default = {
  title: 'Components/TextInput',
  parameters: {
    component: _TextInput.default,
    docs: {
      page: _TextInput2.default
    },
    subcomponents: {
      TextInputSkeleton: _TextInput.TextInputSkeleton,
      'TextInput.PasswordInput': _TextInput.default.PasswordInput
    }
  }
};
exports.default = _default;

var Default = function Default() {
  return /*#__PURE__*/_react.default.createElement(_TextInput.default, {
    type: "text",
    labelText: "Text input label",
    defaultValue: "This is not a default value",
    helperText: "Optional help text"
  });
};

exports.Default = Default;

var Fluid = function Fluid() {
  return /*#__PURE__*/_react.default.createElement(_FluidForm.default, null, /*#__PURE__*/_react.default.createElement(_TextInput.default, {
    type: "text",
    labelText: "Text input label",
    defaultValue: "This is not a default value"
  }));
};

exports.Fluid = Fluid;

var TogglePasswordVisibility = function TogglePasswordVisibility() {
  return /*#__PURE__*/_react.default.createElement(_TextInput.default.PasswordInput, {
    labelText: "Text input label",
    defaultValue: "This is not a default value",
    helperText: "Optional help text"
  });
};

exports.TogglePasswordVisibility = TogglePasswordVisibility;

var withLayer = function withLayer() {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_TextInput.default, {
    type: "text",
    labelText: "First layer",
    defaultValue: "This is not a default value",
    helperText: "Optional help text"
  }), /*#__PURE__*/_react.default.createElement(_Layer.Layer, null, /*#__PURE__*/_react.default.createElement(_TextInput.default, {
    type: "text",
    labelText: "Second layer",
    defaultValue: "This is not a default value",
    helperText: "Optional help text"
  }), /*#__PURE__*/_react.default.createElement(_Layer.Layer, null, /*#__PURE__*/_react.default.createElement(_TextInput.default, {
    type: "text",
    labelText: "Third layer",
    defaultValue: "This is not a default value",
    helperText: "Optional help text"
  }))));
};

exports.withLayer = withLayer;

var Skeleton = function Skeleton() {
  return /*#__PURE__*/_react.default.createElement(_TextInput.TextInputSkeleton, null);
};

exports.Skeleton = Skeleton;