"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _carbonComponents = require("carbon-components");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _RadioTile = _interopRequireDefault(require("../RadioTile"));

var _warning = require("../../internal/warning");

var _excluded = ["value"];

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var prefix = _carbonComponents.settings.prefix;

var TileGroup = /*#__PURE__*/function (_React$Component) {
  (0, _inherits2.default)(TileGroup, _React$Component);

  var _super = _createSuper(TileGroup);

  function TileGroup() {
    var _this;

    (0, _classCallCheck2.default)(this, TileGroup);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "state", {
      selected: _this.props.valueSelected || _this.props.defaultSelected || null,
      prevValueSelected: _this.props.valueSelected
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "getRadioTiles", function () {
      var childrenArray = _react.default.Children.toArray(_this.props.children);

      var children = childrenArray.map(function (tileRadio) {
        var _tileRadio$props = tileRadio.props,
            value = _tileRadio$props.value,
            other = (0, _objectWithoutProperties2.default)(_tileRadio$props, _excluded);
        /* istanbul ignore if */

        if (typeof tileRadio.props.checked !== 'undefined') {
          process.env.NODE_ENV !== "production" ? (0, _warning.warning)(false, "Instead of using the checked property on the RadioTile, set\n            the defaultSelected property or valueSelected property on the TileGroup.") : void 0;
        }

        return /*#__PURE__*/_react.default.createElement(_RadioTile.default, (0, _extends2.default)({}, other, {
          name: _this.props.name,
          key: value,
          value: value,
          onChange: _this.handleChange,
          checked: value === _this.state.selected
        }));
      });
      return children;
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleChange", function (newSelection, value, evt) {
      if (newSelection !== _this.state.selected) {
        _this.setState({
          selected: newSelection
        });

        _this.props.onChange(newSelection, _this.props.name, evt);
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "renderLegend", function (legend) {
      if (legend) {
        return /*#__PURE__*/_react.default.createElement("legend", {
          className: "".concat(prefix, "--label")
        }, legend);
      }
    });
    return _this;
  }

  (0, _createClass2.default)(TileGroup, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          disabled = _this$props.disabled,
          _this$props$className = _this$props.className,
          className = _this$props$className === void 0 ? "".concat(prefix, "--tile-group") : _this$props$className,
          legend = _this$props.legend;
      return /*#__PURE__*/_react.default.createElement("fieldset", {
        className: className,
        disabled: disabled
      }, this.renderLegend(legend), /*#__PURE__*/_react.default.createElement("div", null, this.getRadioTiles()));
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(_ref, state) {
      var valueSelected = _ref.valueSelected,
          defaultSelected = _ref.defaultSelected;
      var prevValueSelected = state.prevValueSelected;
      return prevValueSelected === valueSelected ? null : {
        selected: valueSelected || defaultSelected || null,
        prevValueSelected: valueSelected
      };
    }
  }]);
  return TileGroup;
}(_react.default.Component);

exports.default = TileGroup;
(0, _defineProperty2.default)(TileGroup, "propTypes", {
  /**
   * Provide a collection of <RadioTile> components to render in the group
   */
  children: _propTypes.default.node,

  /**
   * Provide an optional className to be applied to the container node
   */
  className: _propTypes.default.string,

  /**
   * Specify the the value of <RadioTile> to be selected by default
   */
  defaultSelected: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]),

  /**
   * Specify whether the group is disabled
   */
  disabled: _propTypes.default.bool,

  /**
   * Provide an optional legend for this group
   */
  legend: _propTypes.default.string,

  /**
   * Specify the name of the underlying `<input>` nodes
   */
  name: _propTypes.default.string.isRequired,

  /**
   * Provide an optional `onChange` hook that is called whenever the value of
   * the group changes
   */
  onChange: _propTypes.default.func,

  /**
   * Specify the value that is currently selected in the group
   */
  valueSelected: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number])
});
(0, _defineProperty2.default)(TileGroup, "defaultProps", {
  onChange:
  /* istanbul ignore next */
  function onChange() {}
});