"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _ = _interopRequireDefault(require("."));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
class TwoFaceIcon extends _react.default.PureComponent {
  constructor(props) {
    super(props);
    this.toggle = this.onToggle.bind(this);
    this.state = {
      face: 'a'
    };
  }

  toggleState() {
    this.setState(curState => ({
      face: curState.face === 'a' ? 'b' : 'a'
    }));
  }

  onToggle(evt) {
    evt.stopPropagation();
    this.toggleState();
    setTimeout(() => this.toggleState(), this.props.delay || 1500);

    if (this.props.onClick) {
      this.props.onClick(evt);
    }
  }

  render() {
    return _react.default.createElement("a", {
      href: "#",
      onClick: this.toggle,
      title: this.props.title,
      className: (this.props.className || '') + ' ' + (this.state.face === 'b' && this.props.classNameB ? this.props.classNameB : '')
    }, _react.default.createElement(_.default, {
      icon: this.state.face === 'a' ? this.props.a : this.props.b
    }));
  }

}

exports.default = TwoFaceIcon;